set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9422857';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '04003400',
      '10003421',
      '32130404',
      '42410114',
      '14443000',
      '22030232',
      '13424100',
      '11314021',
      '33411023',
      '30301110',
      '23030341',
      NULL,
      '04233330',
      '43322243',
      NULL,
      '20301032',
      NULL,
      '00343103',
      NULL,
      '00120440',
      NULL,
      '10123101',
      '11040114',
      NULL,
      '24013230',
      '33043100',
      '10412424',
      '22313102',
      '11221013',
      '20410342',
      '23304011',
      '21244204',
      '04313321',
      NULL,
      NULL,
      '12433221',
      NULL,
      '02424320',
      NULL,
      '00433130',
      NULL,
      '33401003',
      '20324321',
      NULL,
      NULL,
      NULL,
      NULL,
      '3004222',
      2.385095,
      0,
      NULL,
      NULL,
      '343412',
      NULL,
      ' 4-25-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      4.369399,
      16.953639,
      35.175027,
      NULL,
      NULL,
      10.015869,
      19.830696,
      20.675221,
      2,
      12,
      9,
      4.574879,
      11.234604,
      2,
      NULL,
      13,
      8.950812,
      5,
      NULL,
      NULL,
      1,
      51,
      50.883593,
      73,
      NULL,
      81,
      89.373099,
      '10-14-2002',
      3,
      0,
      27.457782,
      NULL,
      142,
      NULL,
      NULL,
      0.779543,
      5,
      4,
      1,
      NULL,
      1,
      1.019368,
      1,
      NULL,
      0,
      0,
      1,
      0.301172,
      0.767477,
      0.347016,
      1,
      0.627908,
      1,
      NULL,
      1.076522,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-19-1998',
      NULL,
      NULL,
      4.301965,
      9,
      NULL,
      6,
      NULL,
      0.624863,
      1.720001,
      NULL,
      NULL,
      1,
      31.037002,
      1.321617,
      0,
      106.931493,
      NULL,
      NULL,
      NULL,
      '10-17-2000',
      5.126101,
      95.102359,
      55,
      10.480933,
      NULL,
      20,
      45,
      113.837842,
      63,
      94.850496,
      3,
      55,
      ' 1-27-1989',
      NULL,
      NULL,
      16,
      1.753691,
      12.932266,
      NULL,
      5.032591,
      ' 7-11-1995',
      NULL,
      20.000074,
      '10-17-2000',
      0,
      10,
      17.887968,
      8,
      NULL,
      NULL,
      1,
      0,
      1,
      14.494608,
      0.715984,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.804224,
      1,
      ' 6-17-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.811868,
      NULL,
      NULL,
      NULL,
      NULL,
      26.410331,
      ' 5-20-1997',
      NULL,
      '10-16-1981',
      11,
      NULL,
      ' 5- 2-1980',
      NULL,
      63,
      ' 8- 7-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      14,
      ' 1- 6-1999',
      61,
      NULL,
      NULL,
      '11- 8-1976',
      0.028781,
      104.474931,
      '10- 5-1978',
      14.448015,
      86,
      4,
      4,
      NULL,
      73.980931,
      0,
      51.378263,
      ' 7- 2-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


