set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9422857';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1210',
      '42110244',
      '04344120',
      '04330114',
      '12204312',
      '24420201',
      '32420344',
      '34314411',
      '03310230',
      '13014131',
      '21413212',
      '40200201',
      '41002113',
      '33331440',
      '20330213',
      '11311044',
      '21412442',
      '40433210',
      '42021123',
      '04143402',
      '34014344',
      NULL,
      '10134124',
      '21122102',
      '04202011',
      NULL,
      '43110142',
      '00332014',
      NULL,
      '24033033',
      '13132143',
      '14413320',
      '24331433',
      NULL,
      '24412424',
      '02304442',
      '23404030',
      NULL,
      '01204012',
      '44034203',
      NULL,
      '01040110',
      '11442301',
      '42243311',
      '10234331',
      '302',
      NULL,
      3,
      NULL,
      '2203420',
      0.280687,
      39.681599,
      3,
      NULL,
      '301100',
      3.607884,
      NULL,
      '11-25-1997',
      67.674862,
      1.274338,
      20.659346,
      0.307634,
      10,
      5,
      28.770012,
      21,
      16.297068,
      5.113869,
      41,
      8.750377,
      42.117787,
      8.428085,
      18.384438,
      19,
      20,
      16.402741,
      59,
      7,
      NULL,
      NULL,
      17,
      7.561390,
      0.256965,
      91.686625,
      140,
      59.785881,
      NULL,
      110,
      169.094883,
      ' 7- 4-1997',
      17,
      NULL,
      33,
      19.956426,
      157.816826,
      158.682169,
      ' 9-17-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      73,
      6,
      2.925600,
      8,
      11.570428,
      2,
      NULL,
      1,
      0,
      73.836331,
      NULL,
      NULL,
      103,
      4,
      1.660334,
      52.641562,
      NULL,
      NULL,
      NULL,
      ' 4-17-1991',
      119,
      37,
      15.496566,
      NULL,
      77.436969,
      94,
      NULL,
      74.996973,
      NULL,
      NULL,
      35.179305,
      NULL,
      ' 9-10-1999',
      13,
      NULL,
      NULL,
      32.130002,
      6,
      13.740925,
      NULL,
      NULL,
      4.126211,
      5,
      NULL,
      3,
      NULL,
      1,
      12,
      1.147226,
      6,
      NULL,
      16,
      0,
      NULL,
      0.591325,
      2,
      9,
      4,
      4.062871,
      0.762274,
      0,
      0,
      ' 1-15-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      51,
      2.838943,
      ' 7-24-1991',
      NULL,
      NULL,
      NULL,
      55.388013,
      ' 8-15-1993',
      NULL,
      NULL,
      0.460613,
      NULL,
      ' 0-15-1991',
      24.247158,
      58.000499,
      ' 7-25-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      21.691583,
      ' 7-17-1989',
      28.462789,
      27,
      7,
      ' 5-22-1997',
      2,
      2,
      ' 1-18-1986',
      5.875085,
      75,
      4.549240,
      46,
      ' 2-23-1976',
      43.906279,
      0.372546,
      80,
      ' 4-13-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


