set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9422857';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      '3',
      '4',
      '0',
      NULL,
      '1',
      '0',
      '2',
      '2',
      '0',
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '0',
      '0',
      '1',
      NULL,
      '3',
      '0',
      '1',
      NULL,
      NULL,
      '',
      '1',
      '1',
      '1',
      '1',
      '2',
      '',
      '',
      NULL,
      '3',
      '0',
      '1',
      '0',
      '2',
      '4',
      '1',
      '1',
      '0',
      NULL,
      '420',
      '40431144',
      49,
      NULL,
      '1302001',
      1,
      107.764050,
      NULL,
      NULL,
      NULL,
      2.558884,
      NULL,
      ' 6-13-1995',
      80.103047,
      21.013540,
      21.349036,
      15,
      NULL,
      11.960462,
      31,
      14.714501,
      3.693703,
      2.309292,
      30.502297,
      3.744221,
      23.266997,
      NULL,
      2.448097,
      NULL,
      26.000959,
      NULL,
      NULL,
      19,
      65.338743,
      7,
      NULL,
      NULL,
      0,
      NULL,
      130.070552,
      NULL,
      NULL,
      NULL,
      125.091847,
      ' 0-19-1976',
      49.299417,
      0.233321,
      NULL,
      12.117295,
      209.839165,
      82.405500,
      ' 7-18-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      43,
      15,
      15,
      7.517980,
      NULL,
      8,
      '11-28-1999',
      1.566925,
      1.284199,
      88.762135,
      NULL,
      1,
      82,
      1,
      4.903633,
      10,
      NULL,
      NULL,
      NULL,
      ' 3-17-1990',
      102,
      127,
      83.510631,
      51,
      20,
      36.250018,
      36.478322,
      78,
      78,
      118,
      113.583976,
      60,
      '10-27-1986',
      8,
      0,
      0,
      4.900012,
      NULL,
      6,
      4,
      '10- 4-1986',
      9.703107,
      13.635859,
      ' 1- 7-2003',
      7.972420,
      6.692480,
      24.824667,
      3.582237,
      NULL,
      3.868485,
      1,
      NULL,
      1.440602,
      112,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.241240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      77.221561,
      3.501115,
      ' 7-11-2003',
      NULL,
      NULL,
      NULL,
      3.631032,
      ' 7-27-1975',
      22,
      ' 5-10-1996',
      14.767908,
      9.668186,
      NULL,
      70,
      11.291863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      6,
      '10- 8-1982',
      5,
      4,
      39,
      ' 9-23-1976',
      0,
      152,
      NULL,
      NULL,
      2,
      NULL,
      18.088709,
      NULL,
      65,
      1.989116,
      37,
      ' 5-23-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


