set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9422857';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      NULL,
      '3',
      '4',
      '3',
      '3',
      '3',
      '0',
      NULL,
      '3',
      '1',
      NULL,
      '1',
      '1',
      '2',
      NULL,
      '1',
      '0',
      '3',
      NULL,
      '2',
      '4',
      NULL,
      '',
      '4',
      '',
      NULL,
      '2',
      NULL,
      '3',
      NULL,
      NULL,
      '',
      '2',
      '4',
      NULL,
      '3',
      '4',
      '1',
      NULL,
      '3',
      '4',
      NULL,
      '0',
      '332',
      '43444304',
      NULL,
      8.558549,
      NULL,
      NULL,
      69.784657,
      3,
      1,
      NULL,
      5,
      NULL,
      '11-23-1974',
      NULL,
      62,
      8,
      NULL,
      NULL,
      8,
      79.004117,
      5,
      6.419083,
      18,
      34.065185,
      5,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      7.801461,
      NULL,
      17,
      NULL,
      13.453061,
      0,
      NULL,
      29.907748,
      2,
      30.494876,
      NULL,
      NULL,
      '11- 8-1989',
      48.241440,
      NULL,
      32.085758,
      0,
      193,
      106,
      ' 0- 0-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      94,
      22.309490,
      13,
      3,
      8,
      5,
      ' 4-29-1991',
      0.322949,
      0,
      106,
      2.165860,
      1.275076,
      142.755418,
      3,
      1.484717,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-17-1975',
      17.956022,
      22.451250,
      NULL,
      77,
      119.996087,
      NULL,
      106.930395,
      NULL,
      NULL,
      35.220671,
      56.078496,
      48,
      ' 3- 1-2002',
      19.578046,
      2,
      16.830600,
      10,
      NULL,
      42.202803,
      6.284134,
      NULL,
      NULL,
      25,
      ' 4-21-1978',
      1.952129,
      2,
      6.291516,
      0.621902,
      16.069261,
      1.258346,
      1.869208,
      11,
      0.056089,
      4.332882,
      0,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      0.479633,
      ' 5-26-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      115,
      1,
      ' 6-23-1991',
      NULL,
      NULL,
      NULL,
      54,
      NULL,
      48,
      ' 5-18-1987',
      14.017321,
      5.533215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      20.802316,
      ' 9- 9-2002',
      47,
      51.632232,
      12,
      '10-19-1975',
      1,
      NULL,
      ' 3-21-1981',
      13.983569,
      11.619268,
      7.225941,
      40,
      ' 7-21-1998',
      36,
      1,
      197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


