set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9321577';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '30214111',
      '10310002',
      '43232402',
      '02400442',
      '42300313',
      '33313134',
      NULL,
      '20013304',
      '32000411',
      '20334233',
      '32032422',
      '41123203',
      NULL,
      '34312034',
      '00423003',
      '31124414',
      '24003324',
      '20003314',
      NULL,
      '03001321',
      '12142432',
      NULL,
      NULL,
      '13410303',
      '40002212',
      '11331413',
      '22313230',
      '42214244',
      NULL,
      '42411322',
      NULL,
      NULL,
      '01243232',
      '40401401',
      '44014124',
      '00200231',
      '02303013',
      NULL,
      '12134404',
      NULL,
      '41122303',
      '21204234',
      '43244234',
      '42220323',
      NULL,
      '14',
      18,
      17.930499,
      NULL,
      1.168544,
      0,
      3,
      NULL,
      '330414',
      5,
      ' 3- 5-1996',
      ' 7- 0-1985',
      11,
      NULL,
      17.933209,
      15.100034,
      NULL,
      NULL,
      68.635466,
      0,
      0,
      16,
      NULL,
      7,
      27.833514,
      3,
      5.557447,
      14,
      31,
      20,
      50,
      NULL,
      NULL,
      28.893498,
      2,
      2.702539,
      0.683387,
      NULL,
      70.574091,
      125,
      99.117953,
      109,
      NULL,
      NULL,
      2.167860,
      20.158449,
      7,
      21,
      103,
      101,
      '10- 1-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.061080,
      0,
      NULL,
      7,
      11.154755,
      NULL,
      ' 1-20-1979',
      0.635568,
      2.205889,
      NULL,
      1.701079,
      0.975582,
      118,
      NULL,
      5,
      69.783183,
      NULL,
      NULL,
      NULL,
      '10- 3-1998',
      64,
      11.084440,
      66,
      29,
      NULL,
      NULL,
      28.034817,
      75,
      12.814814,
      40,
      60,
      71.463584,
      ' 3-18-1977',
      0.595766,
      9,
      7.548675,
      NULL,
      26,
      NULL,
      3,
      NULL,
      NULL,
      16.612468,
      ' 2- 1-1980',
      11.839649,
      14.520995,
      10,
      0.146521,
      1.173059,
      4,
      1,
      19.793193,
      NULL,
      68.125433,
      2,
      3,
      19.313338,
      6,
      0.231756,
      0.304916,
      0,
      0.947380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      161,
      14.257892,
      ' 8- 3-1998',
      NULL,
      NULL,
      NULL,
      25,
      ' 0-17-1991',
      12.900645,
      ' 5-27-2000',
      12.844480,
      13,
      '11-27-1976',
      44.256832,
      3.527104,
      ' 4-15-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 7- 3-1999',
      7,
      13.067595,
      32.330014,
      ' 0- 2-1997',
      3.614707,
      23.679577,
      NULL,
      18.314875,
      NULL,
      6.355894,
      25.590584,
      ' 4-21-2001',
      44.696601,
      NULL,
      40,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


