set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9321577';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      '0',
      '4',
      NULL,
      '1',
      '2',
      '4',
      '1',
      '4',
      NULL,
      '2',
      '2',
      '0',
      '1',
      '2',
      NULL,
      '0',
      '3',
      '3',
      '0',
      NULL,
      '3',
      '4',
      '',
      '2',
      '',
      '3',
      '4',
      NULL,
      NULL,
      '0',
      NULL,
      '',
      '1',
      '2',
      '2',
      '0',
      NULL,
      '2',
      '4',
      '2',
      NULL,
      '4',
      '4',
      '130',
      '24233123',
      NULL,
      NULL,
      '0420401',
      NULL,
      7.202487,
      NULL,
      NULL,
      '110243',
      1.867032,
      ' 1-12-1991',
      ' 7-18-1975',
      78,
      79.266873,
      32.639393,
      13,
      NULL,
      NULL,
      50,
      16,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      17,
      NULL,
      24,
      13.134802,
      20,
      47.374254,
      11,
      25.621759,
      5.482132,
      NULL,
      9.205675,
      1,
      NULL,
      40,
      NULL,
      77.983685,
      220,
      78,
      ' 2-18-1999',
      NULL,
      14.082352,
      14,
      NULL,
      169,
      NULL,
      ' 4-17-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      56.876002,
      6,
      4.937768,
      9,
      4,
      7.122131,
      ' 7- 7-1982',
      1,
      0.918298,
      NULL,
      NULL,
      1,
      67,
      1,
      0,
      57,
      NULL,
      NULL,
      NULL,
      ' 5-14-1982',
      NULL,
      NULL,
      15.392890,
      NULL,
      41.870419,
      4.317461,
      NULL,
      65,
      NULL,
      67,
      NULL,
      12,
      NULL,
      NULL,
      2,
      1.906263,
      44,
      NULL,
      NULL,
      6.815823,
      ' 6-11-1978',
      8,
      14.063211,
      ' 6-21-1988',
      NULL,
      13.234189,
      NULL,
      19,
      14,
      NULL,
      1,
      9.838177,
      0,
      NULL,
      NULL,
      1,
      1,
      22.587500,
      0.937226,
      NULL,
      1.026759,
      1.037544,
      '10-19-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      174,
      NULL,
      ' 0-20-2002',
      NULL,
      NULL,
      NULL,
      54.357230,
      '11- 9-1985',
      NULL,
      ' 9- 7-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      52,
      ' 0- 3-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      16.672591,
      ' 7-20-1981',
      1.755313,
      27,
      45,
      ' 9-18-1998',
      5,
      NULL,
      ' 7-14-1974',
      NULL,
      4,
      18,
      13,
      ' 3-23-1976',
      50.059826,
      0,
      NULL,
      ' 5- 2-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


