set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3421',
      '33132404',
      '41440342',
      '13411010',
      '03211003',
      '21240043',
      NULL,
      '20102142',
      '40334143',
      '32312403',
      '31031242',
      '34331212',
      '32442213',
      '12440043',
      NULL,
      '12221202',
      '31042211',
      '32402011',
      '30334140',
      '40111032',
      NULL,
      '10234111',
      '32441142',
      '41020241',
      '44142143',
      '12440333',
      '43400431',
      '34143142',
      '01131202',
      '03241340',
      '14404244',
      '01124242',
      '20311403',
      NULL,
      NULL,
      '22344033',
      NULL,
      NULL,
      '11421413',
      '12000133',
      '40001342',
      '00331241',
      NULL,
      '30221113',
      NULL,
      '040',
      '20',
      29.770136,
      4,
      '4212221',
      3.657802,
      1,
      0,
      NULL,
      '223333',
      NULL,
      '10-22-1992',
      ' 8-18-1983',
      73.517345,
      NULL,
      NULL,
      12.146750,
      18,
      13.102922,
      114,
      16,
      5.767181,
      12,
      NULL,
      5,
      19,
      0,
      NULL,
      10.860464,
      NULL,
      NULL,
      46,
      NULL,
      9,
      10,
      86.133304,
      15,
      1,
      NULL,
      86.078212,
      85,
      114,
      6,
      160.091429,
      NULL,
      NULL,
      58.897025,
      9.404457,
      8.547706,
      133.233786,
      NULL,
      ' 2-27-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23,
      3.120425,
      5,
      4.616143,
      6.903759,
      ' 9-21-1985',
      1.110246,
      1.995791,
      43.331273,
      3,
      NULL,
      NULL,
      5.752188,
      1,
      39,
      NULL,
      NULL,
      NULL,
      ' 5- 6-1989',
      3.095029,
      53,
      64,
      NULL,
      51.339653,
      59,
      NULL,
      NULL,
      NULL,
      43,
      77,
      NULL,
      ' 3-24-1994',
      9,
      NULL,
      18.189567,
      40,
      NULL,
      NULL,
      2.971632,
      ' 7-27-1991',
      22,
      10,
      NULL,
      NULL,
      6,
      18,
      13,
      3.254946,
      NULL,
      NULL,
      22.019112,
      1,
      54,
      2,
      6,
      3,
      3.532010,
      NULL,
      1,
      3.535852,
      5.526783,
      '11-27-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      23,
      16.939579,
      ' 6-28-1975',
      NULL,
      NULL,
      NULL,
      11,
      ' 2- 0-2001',
      NULL,
      ' 2-22-1995',
      12.142411,
      0,
      ' 2-16-2001',
      90,
      68,
      ' 6-28-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      18.283878,
      ' 8-17-1996',
      NULL,
      41,
      4,
      ' 9-10-1984',
      0.382461,
      42.674311,
      ' 9-16-1990',
      15,
      4,
      23.716834,
      11.290638,
      NULL,
      29,
      1.421841,
      7,
      ' 3-18-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


