set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2412',
      NULL,
      '32411222',
      '10104244',
      NULL,
      '43032324',
      '44404031',
      NULL,
      NULL,
      '31144040',
      NULL,
      '03432223',
      '40304002',
      '42202411',
      '00323230',
      '30124013',
      '10434240',
      '40414210',
      '32223302',
      '41433134',
      '20200112',
      NULL,
      NULL,
      '22424444',
      '02301423',
      '11242441',
      '12312121',
      '20314112',
      '42421304',
      '41040244',
      '20401414',
      '40240441',
      NULL,
      '42224201',
      NULL,
      '40210124',
      '11441003',
      '02244041',
      '01403312',
      NULL,
      '43323343',
      '14443414',
      '23443034',
      '13101421',
      '14343124',
      NULL,
      NULL,
      NULL,
      15.709905,
      '4403232',
      1.049704,
      43.198171,
      2,
      NULL,
      '412442',
      NULL,
      ' 9-22-1983',
      ' 4-16-1994',
      NULL,
      NULL,
      21,
      20,
      5,
      13,
      37,
      NULL,
      NULL,
      6.092395,
      53.041951,
      11,
      NULL,
      15,
      22.366167,
      13.923597,
      NULL,
      12.721179,
      67.509450,
      21,
      49.939291,
      14,
      NULL,
      NULL,
      NULL,
      61.938187,
      175.277120,
      69.977682,
      209.271077,
      153,
      190.530283,
      NULL,
      14.967939,
      11,
      26,
      17,
      102.242866,
      158,
      ' 5- 8-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.484026,
      20,
      14.817298,
      5.074588,
      NULL,
      NULL,
      ' 4-26-1993',
      NULL,
      NULL,
      48.470675,
      0,
      4.948321,
      89.479614,
      0.717613,
      3,
      38.742648,
      NULL,
      NULL,
      NULL,
      ' 3- 6-1982',
      NULL,
      68.822050,
      30,
      30,
      14,
      79,
      71,
      NULL,
      5.177013,
      59.532330,
      45.660639,
      63.866644,
      ' 7-17-2001',
      31.358932,
      7,
      25,
      85,
      55,
      153,
      0.072315,
      ' 8-12-1976',
      13.330868,
      11,
      ' 7- 1-1982',
      5,
      NULL,
      4,
      9.675677,
      12.146968,
      13.124271,
      0,
      27,
      0.389397,
      23,
      3,
      0,
      9.200657,
      13,
      1,
      0.507522,
      NULL,
      0,
      ' 8-21-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      42,
      41,
      '10-17-1982',
      NULL,
      NULL,
      NULL,
      46.865535,
      ' 1-24-1980',
      45,
      ' 8-12-1975',
      7.129805,
      NULL,
      ' 3-27-1997',
      40,
      17.997032,
      ' 9-21-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      29.077244,
      ' 0-21-1989',
      29.623869,
      NULL,
      4,
      ' 0- 1-1989',
      NULL,
      107,
      ' 4-24-1986',
      2,
      NULL,
      3.899530,
      25,
      NULL,
      NULL,
      0,
      4.721935,
      '11- 8-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


