set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      '4',
      '3',
      '3',
      '0',
      NULL,
      '2',
      '1',
      '4',
      '3',
      NULL,
      '2',
      '1',
      '1',
      '0',
      '3',
      '4',
      '0',
      '0',
      '2',
      '0',
      '3',
      '3',
      NULL,
      '1',
      '',
      '0',
      '1',
      '1',
      '4',
      '4',
      NULL,
      '',
      '0',
      '0',
      NULL,
      '0',
      '4',
      NULL,
      '4',
      '1',
      '0',
      NULL,
      '4',
      '122',
      '00101431',
      NULL,
      NULL,
      NULL,
      3.952032,
      56.766633,
      0,
      NULL,
      '140343',
      NULL,
      ' 0-10-1987',
      ' 2-13-1977',
      106,
      56,
      46.250162,
      23,
      11,
      5.631507,
      65,
      19.817247,
      2.142178,
      2.609188,
      2.243278,
      NULL,
      45.870756,
      15.688275,
      18.797214,
      10.920218,
      1.217564,
      7.931481,
      20,
      NULL,
      34.435615,
      14.322376,
      78.432903,
      22.810940,
      NULL,
      46.140880,
      135.168311,
      58.032700,
      67.454037,
      96.090766,
      74,
      ' 8-16-1980',
      7.605959,
      18.403624,
      35.955229,
      NULL,
      162.768593,
      111.743608,
      ' 0-26-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.223572,
      10,
      8,
      39.314487,
      10.674281,
      1,
      ' 0- 9-1975',
      0,
      0,
      13.310593,
      1.973111,
      1.417091,
      NULL,
      NULL,
      1,
      59.535366,
      NULL,
      NULL,
      NULL,
      ' 9-20-1992',
      63,
      38.987238,
      26,
      65,
      NULL,
      7,
      65,
      46.235938,
      69,
      59,
      16.091744,
      61,
      '11-25-1985',
      25,
      34,
      26.891235,
      39,
      12,
      70,
      4.120564,
      ' 7-20-2000',
      3,
      0,
      ' 0-25-1974',
      2,
      8,
      20,
      14.563595,
      5.510695,
      0.645877,
      NULL,
      7.382677,
      1.766358,
      94,
      NULL,
      NULL,
      NULL,
      27.766976,
      0,
      1,
      0,
      1.568198,
      ' 3-14-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 7-1993',
      NULL,
      NULL,
      NULL,
      28,
      NULL,
      14,
      ' 3-26-1990',
      14,
      NULL,
      NULL,
      38.617834,
      89,
      ' 5-21-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      ' 7-11-1993',
      15,
      NULL,
      NULL,
      ' 3-28-1986',
      4.521780,
      NULL,
      NULL,
      12,
      NULL,
      15,
      41,
      NULL,
      56,
      1.097428,
      38.405541,
      ' 7-13-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


