set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7530402';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0000',
      '41432233',
      '11202034',
      '00314340',
      '13311134',
      NULL,
      NULL,
      NULL,
      '20030320',
      '30210421',
      '11330401',
      '13301431',
      NULL,
      '24041121',
      '34210333',
      '20014401',
      '42100141',
      '00200032',
      '14323412',
      '30022431',
      NULL,
      NULL,
      '14321333',
      '00243314',
      '03101120',
      '31303013',
      '42413331',
      '41321020',
      '10412440',
      '00442233',
      '10422342',
      '11304241',
      '13442001',
      '12321400',
      '24410100',
      '34440424',
      '33304012',
      '32032022',
      '03230441',
      '21103022',
      '23204302',
      '40240132',
      '40214111',
      '21131232',
      '40134024',
      '010',
      '21',
      NULL,
      NULL,
      '0300321',
      1.811133,
      0.656266,
      1,
      NULL,
      '132121',
      1.075422,
      ' 9- 3-1988',
      NULL,
      92,
      NULL,
      18,
      3.877265,
      5.443783,
      11,
      42.339066,
      13.774507,
      NULL,
      9.976890,
      1.400171,
      NULL,
      17,
      7,
      2,
      3,
      2.208242,
      0.719880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.375869,
      0.540954,
      57.714588,
      NULL,
      NULL,
      90,
      70,
      63,
      ' 3-22-1977',
      29,
      13.249012,
      9.405443,
      11,
      106.427087,
      161,
      ' 8-16-1982',
      0.997250,
      2.522757,
      NULL,
      1.915598,
      5.198231,
      2,
      6.663301,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      0.425717,
      1.165260,
      0.391948,
      0.543458,
      1.753372,
      1.886323,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-12-2001',
      16.245527,
      30,
      42.963277,
      4.349243,
      NULL,
      NULL,
      ' 6- 7-1974',
      1.901146,
      3,
      35,
      0,
      3,
      13.730280,
      NULL,
      2,
      17.558961,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      NULL,
      45.665196,
      55,
      27.519188,
      11.512996,
      2,
      2,
      34,
      NULL,
      NULL,
      NULL,
      ' 4- 5-1977',
      9,
      6,
      0.685905,
      13.407701,
      NULL,
      NULL,
      NULL,
      '11- 6-1982',
      1,
      NULL,
      ' 4-18-1994',
      5.647180,
      NULL,
      13.181474,
      12,
      6.947890,
      2.192101,
      1,
      12,
      1.249024,
      16.781983,
      1,
      1.339744,
      17.603182,
      18,
      2,
      2.922146,
      1,
      0.851351,
      NULL,
      2,
      0.467436,
      1,
      ' 3-19-2003',
      2.538364,
      23.141726,
      ' 6-16-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.195639,
      1,
      ' 9- 6-1999',
      34,
      58.653327,
      ' 8-24-1988',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-20-1985',
      25,
      8,
      NULL,
      ' 3- 7-1996',
      5.566781,
      47,
      ' 7- 7-1991',
      1.739455,
      54,
      8.991158,
      30,
      ' 0-21-1992',
      54.744466,
      1.498450,
      96,
      ' 4-10-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


