set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7530402';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1103',
      '31414230',
      '43233114',
      '41132012',
      '01014303',
      '03231323',
      '01043104',
      '14404121',
      '24421042',
      '04203341',
      NULL,
      '22334433',
      '00212214',
      '24121333',
      '00110102',
      '03302240',
      '31023123',
      '43333303',
      NULL,
      '04410332',
      '10334122',
      '03414342',
      '23043414',
      '34243424',
      '13203110',
      '42002012',
      '01332111',
      '12412324',
      '10220123',
      '20040144',
      '24414402',
      '22112140',
      '00222441',
      NULL,
      '34024340',
      '43002004',
      '03244012',
      '44423432',
      NULL,
      '31431024',
      NULL,
      '44434124',
      '10110240',
      '34414313',
      '31404214',
      '202',
      '41',
      NULL,
      NULL,
      '0311302',
      2,
      49.547511,
      0,
      NULL,
      '112224',
      2,
      ' 8-14-2001',
      ' 8-17-1995',
      94.547081,
      NULL,
      18.805124,
      12,
      9,
      6,
      45.261490,
      9,
      NULL,
      9.145568,
      9,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      7,
      10,
      4.874140,
      2.680854,
      5.828223,
      4.690723,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      2,
      46.898139,
      17,
      NULL,
      ' 5-10-1996',
      11.487124,
      3.795090,
      NULL,
      7.288661,
      NULL,
      NULL,
      ' 3- 7-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24.597040,
      65,
      11.857309,
      43.396551,
      24,
      1,
      ' 6-17-1992',
      1,
      0.094818,
      109.052995,
      1,
      0,
      35.878096,
      0,
      1.101120,
      38.945237,
      NULL,
      NULL,
      NULL,
      ' 3-15-1987',
      6.094563,
      NULL,
      0,
      NULL,
      60.439259,
      NULL,
      29,
      9.462987,
      13.036393,
      10.341701,
      51.802433,
      6,
      ' 4- 4-1985',
      3,
      1,
      6.397566,
      16,
      NULL,
      5,
      2,
      ' 4-18-2001',
      2.823485,
      18.355232,
      ' 0-27-1978',
      NULL,
      NULL,
      5.933406,
      1,
      NULL,
      4.394542,
      NULL,
      8.367503,
      1.604996,
      56.957972,
      0.311240,
      1.840247,
      NULL,
      4,
      4.837483,
      7,
      0,
      0,
      ' 4-11-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      20.410778,
      NULL,
      '11- 4-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28.172801,
      NULL,
      1,
      NULL,
      ' 4-18-1981',
      105,
      NULL,
      ' 5-22-1977',
      0.962093,
      4,
      ' 2-10-1975',
      NULL,
      NULL,
      NULL,
      2,
      2,
      5.624173,
      ' 7- 7-1976',
      4.344968,
      2.632111,
      NULL,
      ' 2-12-1998',
      2.697269,
      245.109219,
      ' 2-13-1975',
      0.963965,
      33,
      0,
      86,
      '10-29-1978',
      59,
      1.266680,
      230,
      ' 4-20-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


