set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7530402';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3123',
      NULL,
      '33331322',
      NULL,
      '23432142',
      '30010032',
      '10341302',
      '13320414',
      '31101420',
      '31434312',
      NULL,
      NULL,
      NULL,
      '14023130',
      NULL,
      '30100220',
      '01313320',
      '20321323',
      '40312124',
      '03103121',
      '22323212',
      '42022202',
      '40323233',
      '12303412',
      '34004314',
      '01211204',
      NULL,
      NULL,
      '32420011',
      '34413323',
      '03322113',
      '10420142',
      '13102112',
      NULL,
      '10133003',
      '00120441',
      NULL,
      '02234310',
      NULL,
      '21223203',
      NULL,
      '33141220',
      '44331111',
      NULL,
      '43022012',
      '433',
      '13',
      22,
      4.117480,
      '0420031',
      3,
      55.934517,
      3,
      NULL,
      '332322',
      4.843716,
      NULL,
      ' 3-11-1976',
      NULL,
      109,
      16,
      10.233963,
      NULL,
      9,
      42,
      12.639958,
      6,
      4,
      3.870896,
      15,
      NULL,
      11.757636,
      1.004763,
      5.766037,
      2.972336,
      4,
      9.664328,
      0,
      NULL,
      3.318886,
      13,
      NULL,
      0,
      64.542364,
      0,
      29.514437,
      15.600623,
      68,
      119.406938,
      ' 0-20-1996',
      16.275964,
      NULL,
      12.714204,
      NULL,
      50,
      123.351044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      22.796072,
      8,
      NULL,
      0,
      NULL,
      0.331988,
      NULL,
      84,
      NULL,
      5.857692,
      88.371868,
      3,
      5,
      22,
      NULL,
      NULL,
      NULL,
      '10-11-1997',
      91,
      22.772472,
      22,
      61.733302,
      NULL,
      32,
      58,
      72.668084,
      16.755383,
      5.953791,
      27,
      6,
      NULL,
      NULL,
      9.679574,
      NULL,
      28,
      29.624612,
      5.686767,
      5,
      NULL,
      26,
      1,
      ' 5- 1-1978',
      9.247659,
      6,
      14.562856,
      NULL,
      14.867966,
      1.680685,
      1,
      NULL,
      1.366269,
      39.172602,
      3.329166,
      NULL,
      NULL,
      NULL,
      1,
      3.675651,
      4,
      0.446717,
      ' 7-29-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      127,
      50.930509,
      ' 8- 8-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-28-1978',
      3,
      2,
      '10-18-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.821673,
      ' 1- 8-1979',
      NULL,
      11,
      2.907210,
      ' 4-16-1996',
      4,
      140,
      ' 5-28-1976',
      7,
      NULL,
      14,
      64,
      ' 3-14-2003',
      64,
      1,
      135,
      ' 0-17-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


