set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7530402';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      '2',
      '0',
      '1',
      '0',
      '0',
      '0',
      '3',
      NULL,
      '2',
      '0',
      '4',
      '4',
      '1',
      '0',
      '4',
      '2',
      '3',
      '0',
      NULL,
      '3',
      '3',
      NULL,
      '',
      '4',
      '',
      '3',
      '1',
      '1',
      '2',
      '3',
      '',
      '',
      NULL,
      '1',
      NULL,
      NULL,
      '0',
      NULL,
      '2',
      '1',
      '4',
      '2',
      '3',
      '320',
      '11214314',
      19.472963,
      57.897941,
      '1210010',
      3.194310,
      177.682262,
      2,
      0,
      '032224',
      3,
      ' 5- 0-1998',
      ' 2- 9-1997',
      37.352124,
      219.647117,
      NULL,
      5,
      18,
      13.081116,
      2.373368,
      1.940649,
      4,
      5.464936,
      15,
      4.554966,
      3.780491,
      NULL,
      NULL,
      1.485493,
      NULL,
      5,
      1,
      5,
      38,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      114.425340,
      16.834684,
      87,
      90,
      62,
      ' 1-13-1997',
      9,
      2,
      22.081146,
      7.562362,
      102,
      153.394269,
      ' 9- 9-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      87.911070,
      19,
      38.538041,
      21.449767,
      0.331671,
      ' 7-24-1978',
      0.863084,
      1,
      44.292318,
      3,
      1,
      21.006593,
      3.082608,
      1,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      59,
      46.608471,
      56,
      72.584461,
      NULL,
      NULL,
      48.402922,
      49,
      29.890012,
      3.155144,
      ' 6- 7-1979',
      9,
      1,
      2,
      NULL,
      NULL,
      1.173533,
      2,
      '10- 3-1992',
      0,
      3.181315,
      ' 4-26-1985',
      6,
      4.285533,
      9,
      7,
      NULL,
      4.864427,
      NULL,
      9,
      1,
      NULL,
      0.537997,
      0,
      3,
      28.314816,
      NULL,
      1.298154,
      1.218682,
      1.713005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21.879953,
      ' 6- 1-1994',
      1,
      9.464238,
      ' 1-19-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      9.783558,
      NULL,
      4.791444,
      8,
      NULL,
      ' 8-20-1985',
      3,
      479,
      ' 8-20-1985',
      0.948661,
      16.454008,
      8,
      19.026753,
      '10-10-1984',
      52,
      NULL,
      128,
      ' 4-25-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


