set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9519135';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '1',
      NULL,
      '1',
      '0',
      '2',
      '1',
      '1',
      '4',
      '1',
      '1',
      '2',
      '3',
      '3',
      '0',
      '0',
      '2',
      '4',
      '1',
      '4',
      '1',
      '0',
      '2',
      '',
      '3',
      '',
      '4',
      '0',
      '1',
      '3',
      '4',
      '',
      NULL,
      '4',
      '0',
      '4',
      '0',
      '4',
      NULL,
      NULL,
      '3',
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      47,
      34,
      '3102020',
      2.351553,
      0,
      3,
      NULL,
      '244234',
      4,
      ' 5- 8-1989',
      NULL,
      24,
      25.275368,
      NULL,
      16.478095,
      7.236821,
      6.169666,
      NULL,
      0,
      29,
      4.843617,
      40,
      4,
      NULL,
      2,
      18.959983,
      18.357076,
      9,
      NULL,
      29,
      26.206302,
      23.120101,
      NULL,
      10.892711,
      10.791293,
      NULL,
      29.189918,
      66.553955,
      125.562801,
      154,
      61,
      NULL,
      ' 2- 1-2000',
      3,
      37,
      4,
      15.772332,
      40.134888,
      NULL,
      ' 3- 1-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.684596,
      3.579020,
      0.076095,
      0,
      5,
      ' 0-22-1974',
      NULL,
      2.806155,
      120.333750,
      NULL,
      1.923282,
      61.138420,
      NULL,
      NULL,
      67,
      NULL,
      NULL,
      NULL,
      '11- 1-1982',
      103.395418,
      120.652238,
      94.715158,
      115,
      76,
      64,
      106.691428,
      44.081504,
      103,
      43,
      77.387996,
      NULL,
      ' 5-26-1975',
      11,
      29.710491,
      3.750946,
      50.384652,
      48,
      NULL,
      NULL,
      NULL,
      14,
      1.593468,
      ' 1- 8-1989',
      1,
      4.621287,
      4.309391,
      0.357260,
      22.274195,
      12.589165,
      0,
      9.553925,
      NULL,
      31.964122,
      NULL,
      0,
      2.796911,
      17,
      7.564907,
      3,
      2.935054,
      NULL,
      ' 7-12-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      184,
      NULL,
      ' 4- 2-2002',
      NULL,
      NULL,
      NULL,
      58,
      ' 5-24-1995',
      4.169713,
      '10- 0-1991',
      4.151727,
      NULL,
      ' 9-24-1985',
      25,
      84,
      ' 0-23-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      24,
      NULL,
      48.887301,
      22.060754,
      28,
      ' 1- 7-1993',
      1.822257,
      75.581903,
      ' 8-29-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


