set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5800019';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0033',
      NULL,
      '30442343',
      '20310440',
      '11023322',
      NULL,
      '33213143',
      '21434211',
      '10124440',
      '12111433',
      '32322213',
      '11313403',
      '23323424',
      NULL,
      '33042044',
      '24121243',
      NULL,
      NULL,
      '12041432',
      '42332444',
      NULL,
      '40110234',
      '00313124',
      NULL,
      '41241041',
      '13202440',
      '14123021',
      NULL,
      '20302330',
      '42224414',
      '43010402',
      '22312212',
      '23432232',
      '43343312',
      NULL,
      '04232303',
      '31431402',
      '42344100',
      '41133033',
      '11030440',
      '03230430',
      '32300043',
      '14414134',
      '30143110',
      '00200124',
      '',
      NULL,
      NULL,
      NULL,
      '3243233',
      NULL,
      0.362057,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      34.694721,
      NULL,
      NULL,
      8,
      16.436212,
      10.988200,
      NULL,
      11.123946,
      NULL,
      10,
      15,
      NULL,
      24,
      13.603581,
      27.302387,
      7.984294,
      13,
      12.839294,
      2.128173,
      21.420142,
      22.656447,
      NULL,
      30,
      6,
      NULL,
      70,
      3,
      44.860458,
      28,
      157.940133,
      134.307762,
      NULL,
      52.111880,
      4,
      24,
      9.863386,
      16,
      NULL,
      NULL,
      2,
      2.370570,
      7,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0.253013,
      2.565127,
      2,
      NULL,
      0.995644,
      3.402747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      51,
      65,
      19,
      38,
      65,
      37.665757,
      22.069693,
      44.978388,
      NULL,
      23.287847,
      57.805654,
      NULL,
      4,
      12,
      3.305050,
      NULL,
      18.162013,
      10,
      NULL,
      NULL,
      4.158389,
      3,
      NULL,
      5,
      NULL,
      NULL,
      1,
      4.668587,
      0.045388,
      NULL,
      1,
      NULL,
      17.404056,
      0.904464,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44,
      44,
      24.671431,
      NULL,
      0,
      54,
      NULL,
      5.098247,
      22,
      15.594679,
      10,
      NULL,
      36.864230,
      0.382021,
      131,
      NULL,
      NULL,
      NULL,
      NULL,
      0.362667,
      22,
      13,
      NULL,
      24,
      NULL,
      112,
      43.847525,
      NULL,
      NULL,
      5.399889,
      NULL,
      1,
      3,
      139,
      0.576106,
      2,
      117,
      3,
      NULL,
      107,
      3.626934,
      0,
      160.896665,
      15,
      13,
      61.715421,
      0,
      14.740420,
      0,
      1.925461,
      1,
      NULL,
      NULL,
      0.143456,
      NULL,
      38.532449,
      8,
      25.597181,
      50,
      0,
      6,
      6.524957,
      NULL,
      0.394312,
      2.906943,
      NULL,
      20.960621,
      1.080035,
      5,
      NULL,
      1.313504,
      1.812453,
      1,
      11,
      1.185138,
      1,
      3,
      31,
      48.030407,
      NULL,
      30,
      3,
      19.233811,
      0.967656,
      16.264356,
      0,
      NULL,
      1.482689,
      4.478681,
      2.404500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


