set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6607548';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4433',
      '01421411',
      '03001442',
      NULL,
      '44404013',
      '24101241',
      NULL,
      '03311323',
      '33423212',
      '21010330',
      '01221020',
      NULL,
      '34142304',
      '01301140',
      NULL,
      NULL,
      '12044132',
      '21120410',
      '34001431',
      NULL,
      '03441400',
      '43241033',
      '03404204',
      '21140044',
      '21300324',
      '12222102',
      NULL,
      '12402412',
      '24011301',
      NULL,
      '23432242',
      '21214344',
      '21113013',
      '01224401',
      '02421344',
      '00312234',
      '04040102',
      '01014104',
      '11233013',
      '31402440',
      NULL,
      '13100023',
      '04342420',
      '01200433',
      '42141134',
      '443',
      NULL,
      NULL,
      NULL,
      '3310124',
      2,
      1.701801,
      2,
      NULL,
      '034144',
      3.992177,
      '10-25-1995',
      NULL,
      11.006729,
      NULL,
      8,
      15,
      23,
      NULL,
      60.772403,
      11,
      NULL,
      2.960736,
      5,
      4.086473,
      28.257475,
      25.203416,
      22,
      0.543307,
      6.233156,
      7,
      15,
      13.382706,
      4.151723,
      1,
      70,
      29.830783,
      0,
      NULL,
      NULL,
      15,
      208.201812,
      56,
      141,
      ' 2- 4-1975',
      59,
      15.977737,
      5,
      35.699985,
      218,
      107.752301,
      ' 0-19-1976',
      0,
      1,
      3.554941,
      2,
      0,
      1,
      2,
      NULL,
      1,
      0,
      1,
      2,
      1.526436,
      0,
      1,
      0.976103,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-27-2001',
      27,
      23.834775,
      3,
      7,
      NULL,
      2,
      ' 5- 0-1990',
      0,
      1.667839,
      8.869150,
      0.617580,
      0,
      83,
      0.275100,
      0.935670,
      4.966976,
      NULL,
      NULL,
      NULL,
      ' 1-10-1989',
      86.982230,
      62.306342,
      NULL,
      50.752521,
      35,
      45,
      41.543862,
      NULL,
      27,
      73.331451,
      34.827127,
      NULL,
      '11-22-1997',
      2.851357,
      25.994881,
      10.737976,
      44.788601,
      28.170145,
      81,
      9.161811,
      ' 7-15-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1.070102,
      ' 3- 2-1992',
      273.461937,
      12.355072,
      ' 2-24-1982',
      2.763251,
      4.758599,
      ' 2- 8-1994',
      53,
      ' 8-27-1979',
      37.620556,
      ' 2-18-1997',
      3.600604,
      3,
      ' 0- 7-1988',
      46.096077,
      15,
      NULL,
      7,
      9.760240,
      ' 2-14-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      12.791442,
      ' 6-14-1990',
      62,
      43.250107,
      47,
      ' 5- 1-1998',
      0.080250,
      NULL,
      ' 7-29-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13);
commit;
end;
/


