set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6607548';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0403',
      '00243240',
      '11112024',
      NULL,
      '34224121',
      NULL,
      '24243130',
      '33441424',
      '02144222',
      '04043334',
      '11110210',
      '10322220',
      '42222040',
      '32001102',
      '21421010',
      '42311313',
      '40131132',
      '32334042',
      NULL,
      '02212314',
      '34230414',
      '23320123',
      '10014412',
      '44132422',
      '04331321',
      '12424204',
      '04404302',
      '40040424',
      '41411313',
      NULL,
      '02402411',
      '23124203',
      '02011344',
      '21114204',
      '40024442',
      '32240003',
      '31122041',
      '43314312',
      '43343012',
      '23221410',
      '33101313',
      '42334334',
      '20122331',
      NULL,
      '31441100',
      NULL,
      '04',
      21,
      15.841953,
      '0141131',
      2.258444,
      15,
      1,
      NULL,
      '421410',
      1.799817,
      ' 7- 7-1990',
      ' 9-17-1979',
      67.789817,
      NULL,
      1.057520,
      12,
      0,
      6.414475,
      61,
      9,
      9,
      0.593743,
      NULL,
      8,
      2.809427,
      21,
      38,
      13.757819,
      14.365851,
      NULL,
      55,
      1.869691,
      NULL,
      1,
      119.676317,
      22,
      1,
      36,
      60.912546,
      67,
      NULL,
      217.452749,
      185.987598,
      '11-28-1999',
      36,
      68,
      36.307243,
      35.320517,
      NULL,
      25,
      ' 2-23-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      92,
      9.507310,
      6.917540,
      NULL,
      1,
      1.148848,
      ' 6-15-1989',
      0.734463,
      0.516927,
      49.666108,
      0.350156,
      0.977283,
      176.143649,
      NULL,
      1.011681,
      112.921581,
      NULL,
      NULL,
      NULL,
      NULL,
      118,
      66,
      71,
      74.638012,
      NULL,
      37.139700,
      NULL,
      86.638813,
      64.206655,
      79,
      79,
      63.177039,
      NULL,
      38,
      35,
      23.943682,
      105.898357,
      70,
      121.187502,
      13,
      NULL,
      16.044864,
      17,
      NULL,
      13.693110,
      12.637984,
      25.424483,
      10,
      28,
      12,
      1,
      1,
      1,
      47.751535,
      0.061453,
      0,
      10,
      14.346140,
      0.029005,
      1.169620,
      1,
      1.876788,
      ' 0-17-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 8-12-1999',
      NULL,
      NULL,
      NULL,
      21,
      ' 6-11-1982',
      4,
      ' 3-20-1975',
      11,
      NULL,
      NULL,
      76.717344,
      107,
      ' 6- 4-1980',
      0.103879,
      0,
      '10-15-1988',
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      ' 4-21-1981',
      15,
      NULL,
      48,
      ' 3- 4-1994',
      0,
      39.133480,
      '10-12-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


