set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9817670';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      NULL,
      '1',
      '4',
      NULL,
      '1',
      '0',
      '0',
      '3',
      '0',
      NULL,
      '0',
      '0',
      '4',
      '0',
      '2',
      NULL,
      '3',
      '3',
      '1',
      '4',
      '1',
      '0',
      '',
      '0',
      '',
      '0',
      '3',
      '3',
      '2',
      '4',
      '',
      '',
      '2',
      '0',
      '0',
      '1',
      '1',
      NULL,
      '3',
      NULL,
      '1',
      '1',
      '3',
      '011',
      NULL,
      NULL,
      69,
      '1223034',
      3,
      1,
      0,
      NULL,
      '304330',
      0.306503,
      ' 1- 7-1982',
      ' 7-29-1985',
      28.283446,
      82.091382,
      2.771843,
      12,
      18,
      11,
      89,
      16.706570,
      0,
      NULL,
      22,
      0,
      34,
      18,
      17.250637,
      16,
      2,
      5,
      11,
      11,
      36.736762,
      NULL,
      56.632881,
      15.252221,
      NULL,
      12,
      31,
      61.434396,
      143,
      16.213953,
      NULL,
      ' 5-19-1993',
      5.440701,
      NULL,
      16,
      NULL,
      1,
      NULL,
      ' 1-28-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.195681,
      21,
      NULL,
      3.098861,
      1,
      NULL,
      NULL,
      NULL,
      154,
      1.957663,
      NULL,
      51.421717,
      0.362972,
      0,
      26.486319,
      NULL,
      NULL,
      NULL,
      ' 3-29-1980',
      6.057757,
      42,
      17,
      31,
      1,
      NULL,
      22.023294,
      NULL,
      24.469941,
      51,
      34.969046,
      1.091157,
      ' 7-20-1974',
      27,
      25.258905,
      20.392717,
      70.616486,
      NULL,
      69,
      2.468040,
      ' 0-27-1979',
      1.308347,
      5,
      ' 3-19-1995',
      6.238819,
      3,
      0.223233,
      2.279490,
      NULL,
      8,
      1.727784,
      5,
      2,
      25,
      NULL,
      0,
      4,
      9,
      4.971924,
      NULL,
      1,
      NULL,
      '11- 7-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      9.605430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      ' 1-29-2003',
      26,
      ' 0-17-1999',
      NULL,
      4.214741,
      ' 8-12-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      11.342202,
      ' 1- 0-1996',
      2.006368,
      NULL,
      5,
      NULL,
      0,
      68,
      ' 5-10-2000',
      12.930381,
      36.972960,
      5,
      35.371003,
      NULL,
      NULL,
      1.897184,
      NULL,
      ' 0-24-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


