set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9817670';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      '1',
      '1',
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '2',
      '2',
      '0',
      '4',
      NULL,
      '3',
      '3',
      '4',
      NULL,
      NULL,
      '2',
      '4',
      '1',
      '2',
      '',
      '3',
      NULL,
      NULL,
      '4',
      '0',
      '1',
      '3',
      '',
      '',
      '3',
      '4',
      NULL,
      '0',
      '3',
      NULL,
      '0',
      '2',
      '3',
      '0',
      '2',
      NULL,
      '00121430',
      45,
      24.912121,
      '2203302',
      0,
      33,
      NULL,
      1,
      NULL,
      0.796760,
      ' 2-22-1979',
      ' 0-11-1979',
      46.930045,
      18.012147,
      39,
      10.759395,
      26.974987,
      17,
      125.545687,
      1,
      3.601477,
      16,
      37.493758,
      2,
      18.164653,
      16,
      21,
      NULL,
      21.054462,
      14,
      18,
      5.307572,
      NULL,
      16,
      35.584951,
      14,
      0.252504,
      52.456529,
      151.937049,
      83.140702,
      2,
      58.150644,
      1,
      ' 1-12-1985',
      56,
      46.328259,
      26,
      35.589983,
      181,
      NULL,
      ' 1- 3-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33.470354,
      8,
      0.530507,
      7.462529,
      2.649701,
      2,
      ' 2- 3-1985',
      1,
      0.916170,
      73,
      0,
      2,
      51.856009,
      0,
      1,
      43,
      NULL,
      NULL,
      NULL,
      ' 6- 4-1985',
      12,
      5,
      11.703105,
      NULL,
      NULL,
      56,
      67,
      7.687600,
      5.001062,
      51.383154,
      45,
      16,
      '10-14-1995',
      19,
      12.562832,
      NULL,
      NULL,
      81,
      NULL,
      9.050701,
      '11- 2-2002',
      11,
      3,
      NULL,
      10.761622,
      NULL,
      5,
      14,
      13.368079,
      5.561278,
      NULL,
      8,
      0,
      85,
      5,
      NULL,
      10.464020,
      29,
      2.494017,
      2.258852,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30,
      ' 7- 9-1979',
      NULL,
      NULL,
      NULL,
      30.324854,
      ' 4-14-1982',
      22,
      NULL,
      NULL,
      0.234804,
      ' 3-13-1992',
      43,
      46.452618,
      '10- 3-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      23.374760,
      NULL,
      5,
      NULL,
      NULL,
      ' 7-24-1974',
      0,
      43.326551,
      NULL,
      NULL,
      31.694961,
      6.064209,
      25,
      ' 8- 1-2001',
      NULL,
      0.206135,
      131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


