set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8408911';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1102',
      '11234011',
      NULL,
      NULL,
      '42130112',
      NULL,
      '03130143',
      '30110111',
      '22322440',
      '02443111',
      '34404121',
      '34201404',
      '01442042',
      '04140024',
      '01230003',
      '01302142',
      NULL,
      '20240112',
      '31330114',
      '11310340',
      '34220210',
      '12313344',
      '34342034',
      '04444020',
      '34432044',
      '42420434',
      '13301333',
      '42304234',
      '31241242',
      '00012401',
      '24111231',
      '41013000',
      NULL,
      '20301343',
      '34304343',
      '32241144',
      '02000142',
      '43143314',
      '42134330',
      '20400322',
      '11234111',
      '04224314',
      '43221133',
      NULL,
      '03331122',
      '',
      '',
      NULL,
      NULL,
      '0000114',
      2,
      1.953809,
      1,
      NULL,
      '314241',
      NULL,
      NULL,
      '11-15-1986',
      NULL,
      NULL,
      14.225356,
      6,
      18.298165,
      4,
      44,
      6.256590,
      10.805780,
      8.905783,
      2,
      NULL,
      13,
      NULL,
      15,
      7.062635,
      12.118866,
      5,
      NULL,
      3,
      16.540026,
      13,
      51.946534,
      7.508184,
      NULL,
      59.505014,
      5.091532,
      35,
      80,
      104,
      150,
      ' 4- 1-1992',
      33.855256,
      15,
      24,
      NULL,
      50.174300,
      133,
      ' 6- 8-1984',
      15,
      20.263209,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.794485,
      2.317510,
      NULL,
      NULL,
      0.986057,
      15.980486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-18-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-20-1998',
      NULL,
      17,
      NULL,
      61.921463,
      45.851475,
      79,
      41,
      46.550772,
      NULL,
      NULL,
      28.008254,
      60,
      '11- 9-1995',
      NULL,
      5.531597,
      0,
      20,
      19.195726,
      NULL,
      NULL,
      ' 9-26-1978',
      20.423688,
      12.225317,
      ' 3- 6-1978',
      10.402314,
      9,
      9.302697,
      3,
      13,
      12.097063,
      NULL,
      10.938619,
      NULL,
      14,
      4.723475,
      6,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-16-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.935079,
      12,
      NULL,
      NULL,
      0.729760,
      187.263679,
      NULL,
      NULL,
      27.398870,
      15,
      61,
      NULL,
      22.507927,
      1,
      129.157059,
      ' 6-29-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47.088292,
      77,
      58,
      37.157048,
      77.781213,
      168,
      NULL,
      69,
      NULL,
      44,
      1.128713,
      1.057948,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.837125,
      18,
      2.015246,
      2,
      138.504658,
      NULL,
      8.467008,
      16.162226,
      1.431863,
      NULL,
      0.169144,
      1,
      0.561236,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      53,
      1,
      9.767030,
      NULL,
      7.969019,
      0.777895,
      0.301473,
      1,
      0,
      8.041462,
      0.254863,
      2,
      62,
      NULL,
      86,
      NULL,
      4,
      71.234146,
      22.202362,
      3.778780,
      NULL,
      7.321339,
      90,
      2.367614,
      NULL,
      3,
      9,
      0,
      7.780654,
      0.041703,
      4.282473,
      1.320259,
      1,
      10,
      NULL,
      ' 3-19-2002',
      NULL,
      ' 0- 0-1982',
      ' 4- 9-1989',
      ' 9-14-1993',
      '10-21-1984',
      NULL);
commit;
end;
/


