set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7700718';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1301',
      '20022134',
      NULL,
      '00111102',
      '13304220',
      '43411204',
      '33041040',
      NULL,
      '13210012',
      '11031233',
      '42411241',
      '01322232',
      '20014134',
      NULL,
      '11333341',
      '10220011',
      '43100420',
      '03304410',
      '21042223',
      '01134333',
      NULL,
      '22301244',
      '03343134',
      '22041344',
      '03102132',
      '10034111',
      '43244223',
      NULL,
      '41320102',
      '32112332',
      NULL,
      '13000401',
      '41440013',
      NULL,
      '11332030',
      '34210433',
      '42002224',
      '22123430',
      '14342030',
      '13332211',
      '11131203',
      NULL,
      '10211232',
      '22401024',
      NULL,
      '140',
      '20',
      NULL,
      NULL,
      '2114320',
      3.821097,
      10.886476,
      NULL,
      NULL,
      '214214',
      3.400599,
      ' 8-22-2003',
      ' 5-21-1988',
      NULL,
      NULL,
      15.130177,
      5.462280,
      NULL,
      NULL,
      11,
      13,
      NULL,
      9.662242,
      NULL,
      7.859547,
      13,
      NULL,
      1,
      NULL,
      19.561093,
      7.390504,
      22.082530,
      8.554562,
      19,
      10,
      NULL,
      4.173919,
      NULL,
      NULL,
      116,
      0.824305,
      NULL,
      142.867744,
      99.499065,
      ' 3- 0-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      1,
      3,
      0,
      2.029628,
      NULL,
      1,
      NULL,
      1.281608,
      3,
      0,
      1.076848,
      NULL,
      0.871623,
      1.837375,
      0.059339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.670821,
      8.115340,
      8,
      3.322262,
      9.380693,
      1.600129,
      '10-12-1983',
      1.809587,
      1.201668,
      99.476041,
      NULL,
      NULL,
      24,
      0.672339,
      0,
      68.410092,
      0.341047,
      1,
      80.200586,
      '10-17-1997',
      NULL,
      79.307986,
      NULL,
      NULL,
      77.303138,
      40.174939,
      NULL,
      0.763153,
      NULL,
      41,
      NULL,
      NULL,
      ' 0-24-1998',
      3.382091,
      21,
      15,
      16,
      59.149331,
      44,
      8.396416,
      ' 3- 2-1985',
      3.480680,
      NULL,
      ' 1-25-1978',
      9.426308,
      7,
      7.091734,
      18,
      16,
      7.431576,
      1,
      2,
      0,
      81.940191,
      0,
      NULL,
      1.821655,
      24,
      NULL,
      1.356626,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.744428,
      ' 0- 5-1998',
      49.185044,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-14-1974',
      21.243438,
      '10-16-1990',
      NULL,
      3,
      '10-23-1988',
      79.738439,
      NULL,
      ' 0-21-1995',
      5.262590,
      NULL,
      ' 7-29-1977',
      2.161083,
      NULL,
      ' 6-18-2000',
      0,
      NULL,
      8,
      NULL,
      37,
      20,
      4,
      ' 3-24-2003',
      0.826454,
      172,
      ' 4-12-1986',
      3,
      3,
      NULL,
      13,
      ' 9- 1-1993',
      57,
      0.159939,
      149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.257930);
commit;
end;
/


