set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8732967';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0124',
      '40000141',
      '41202233',
      NULL,
      '43401012',
      '44010042',
      '14202341',
      '13021002',
      '31413112',
      '42102442',
      NULL,
      NULL,
      NULL,
      '14403141',
      '03010013',
      '03420203',
      '01204022',
      '02022441',
      '23342223',
      '31334044',
      '10132343',
      '02110222',
      '11344444',
      '21423010',
      '32030240',
      '01212034',
      NULL,
      '22210234',
      '34242242',
      '01243443',
      '34241010',
      NULL,
      '32031444',
      '04121424',
      '44001043',
      '04033003',
      NULL,
      '44311340',
      '04204414',
      '01024041',
      NULL,
      '31241204',
      NULL,
      '22012102',
      '10311424',
      '304',
      '42',
      NULL,
      NULL,
      '1110133',
      2.352149,
      1,
      0,
      NULL,
      '014030',
      3,
      NULL,
      ' 5-25-1987',
      29.140217,
      NULL,
      22,
      10,
      10.934837,
      12.480794,
      NULL,
      6,
      5,
      13,
      36.725675,
      12.167522,
      5,
      18,
      18,
      10.502742,
      11.398787,
      13.485803,
      NULL,
      9,
      23.639531,
      3.738901,
      105,
      1.718236,
      NULL,
      101.234041,
      68,
      99,
      142.294425,
      217.157563,
      33.938719,
      '10-22-1986',
      75,
      27,
      38.990774,
      3,
      NULL,
      119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21.021289,
      17.715415,
      19.404168,
      4,
      NULL,
      0,
      ' 2-13-1993',
      NULL,
      0,
      26.687187,
      0,
      0.064406,
      111,
      1.627759,
      0.210197,
      94,
      NULL,
      NULL,
      NULL,
      ' 7-24-1991',
      NULL,
      66.258100,
      27,
      73.605944,
      NULL,
      83,
      24,
      31,
      NULL,
      6,
      19.754266,
      3,
      ' 1-17-1977',
      35.934605,
      15,
      28,
      50.560765,
      15,
      9,
      4.828753,
      ' 4-26-1988',
      15.819901,
      19.594717,
      ' 8-10-1984',
      10.386264,
      19,
      NULL,
      NULL,
      5.771515,
      6,
      1.464758,
      NULL,
      NULL,
      25.911307,
      1,
      7.198213,
      4.797945,
      9,
      0,
      NULL,
      NULL,
      0,
      '11- 4-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.719746,
      ' 1- 9-1974',
      NULL,
      NULL,
      NULL,
      13,
      ' 8-16-1995',
      NULL,
      ' 7- 2-1974',
      NULL,
      6.916114,
      ' 7-13-1997',
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      ' 9-25-1975',
      NULL,
      NULL,
      NULL,
      0,
      3,
      13,
      ' 7-12-2000',
      54.473418,
      22.925203,
      NULL,
      NULL,
      0,
      34,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


