set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8514545';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3313',
      '10222212',
      '42331413',
      '43403330',
      NULL,
      '20303322',
      '04234432',
      '40103342',
      '32314230',
      '02022024',
      '01242112',
      '03234114',
      '21203110',
      '42002444',
      '33423120',
      '12342143',
      '31342344',
      '10003030',
      NULL,
      '03444013',
      '03042134',
      '12410110',
      NULL,
      NULL,
      '13120333',
      '34020200',
      '14414032',
      '42020423',
      '34431243',
      '30200043',
      '22121214',
      '01023244',
      '13430434',
      '30242313',
      NULL,
      '31332213',
      '20330424',
      NULL,
      '44344114',
      NULL,
      NULL,
      NULL,
      '21010012',
      '03030401',
      '14031214',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      '110410',
      NULL,
      ' 2-20-1982',
      ' 1-29-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      8,
      2.480314,
      19,
      NULL,
      11,
      NULL,
      NULL,
      2,
      4.958366,
      10.039251,
      7.352641,
      0,
      8,
      2,
      4,
      29,
      11.714248,
      79.323752,
      13.040756,
      NULL,
      17.796724,
      92,
      31.460307,
      61,
      48.957985,
      8,
      ' 4-14-1982',
      26,
      6.652953,
      25.677130,
      10.131700,
      NULL,
      164,
      ' 4-25-1992',
      1,
      0.653745,
      6,
      1.313450,
      NULL,
      NULL,
      NULL,
      NULL,
      0.205177,
      1,
      0.235075,
      1,
      0,
      1.933038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 1-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 5-1998',
      10,
      77,
      6,
      5.943731,
      57,
      NULL,
      12.166031,
      48,
      23,
      NULL,
      NULL,
      20.162243,
      NULL,
      NULL,
      1,
      NULL,
      5,
      32.053197,
      NULL,
      3.601060,
      ' 7-13-1993',
      NULL,
      2,
      ' 6-16-1982',
      1.746388,
      0.811905,
      3,
      NULL,
      2.227887,
      4.810334,
      NULL,
      7.145346,
      NULL,
      28.368446,
      9,
      2.021122,
      10.102649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      0.479718,
      NULL,
      0.108323,
      211.753467,
      ' 7-17-1975',
      7.432027,
      52,
      1.421073,
      NULL,
      ' 0- 4-1982',
      37.464570,
      0.918051,
      215,
      ' 8- 3-1983',
      NULL,
      NULL,
      NULL,
      58.649301,
      NULL,
      1.840968,
      16.312139,
      74.184708,
      92,
      NULL,
      87,
      9.049290,
      19.629497,
      4.966524,
      53.762050,
      1,
      1,
      182,
      NULL,
      NULL,
      NULL,
      1.459912,
      NULL,
      139.084616,
      1,
      1,
      NULL,
      45,
      NULL,
      77,
      0.565010,
      6,
      0.148456,
      NULL,
      NULL,
      0,
      0,
      1,
      20,
      66,
      NULL,
      10.167815,
      28,
      63,
      0,
      NULL,
      NULL,
      1,
      11.261167,
      NULL,
      3.854021,
      0.602123,
      55,
      1,
      65.342535,
      NULL,
      0.520302,
      NULL,
      NULL,
      NULL,
      11,
      25.848028,
      85,
      8.134780,
      53,
      9,
      NULL,
      NULL,
      2,
      0.834434,
      2,
      1.770364,
      1.921988,
      50.992399,
      ' 9-26-1999',
      ' 5- 5-1975',
      '11-17-1993',
      ' 3-22-1995',
      ' 7- 7-1993',
      ' 4-27-1996',
      ' 5-15-1986',
      NULL);
commit;
end;
/


