set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4434',
      '04040122',
      '14432102',
      NULL,
      NULL,
      '44224302',
      NULL,
      '32201322',
      '41240002',
      '11002420',
      '04211114',
      '41132224',
      '14012312',
      '14042202',
      '43341104',
      '11224302',
      '30222411',
      '23444041',
      '04012343',
      '40104014',
      '13133223',
      '42320412',
      NULL,
      NULL,
      '34231422',
      '04241320',
      '43334432',
      '10223232',
      NULL,
      '30421310',
      '21342314',
      '22103222',
      '10001200',
      '32111043',
      '32410422',
      '00424422',
      '14241211',
      '34444024',
      '42020031',
      '32043000',
      '14412402',
      '00412132',
      '23142230',
      NULL,
      '01120322',
      '340',
      '44',
      19,
      NULL,
      '0420333',
      1.712045,
      186,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-29-1997',
      118,
      NULL,
      8,
      NULL,
      13.542407,
      12,
      76.187337,
      4,
      NULL,
      4.765979,
      12.495966,
      13,
      28.625228,
      19,
      20,
      22.234765,
      NULL,
      NULL,
      33,
      0,
      8,
      NULL,
      60,
      10,
      1.254855,
      85,
      110,
      NULL,
      38,
      183,
      NULL,
      ' 1-23-1989',
      30,
      43,
      31.747227,
      30.416176,
      90.031183,
      27.239276,
      ' 7-12-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      93.655610,
      13.097984,
      19.890078,
      10.302791,
      5.076027,
      NULL,
      ' 4- 9-1998',
      0.735876,
      NULL,
      166.260493,
      1,
      1,
      NULL,
      NULL,
      3.020016,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-17-1978',
      30.508575,
      NULL,
      94.109590,
      76.374708,
      78.685650,
      21.283995,
      111,
      88,
      70,
      NULL,
      51,
      101.802436,
      '10-25-1994',
      12.865155,
      NULL,
      NULL,
      35.505103,
      16,
      NULL,
      4.864062,
      ' 9-18-2001',
      1,
      13.553551,
      ' 3- 1-1978',
      NULL,
      1,
      18,
      2,
      NULL,
      1.446314,
      1,
      4.448102,
      1.087753,
      100.975896,
      0,
      NULL,
      0.499027,
      0,
      1,
      0.920006,
      4,
      NULL,
      ' 3-13-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      126.942378,
      1.876773,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      NULL,
      7,
      ' 1- 4-1992',
      9,
      7.346918,
      ' 2-24-2002',
      108,
      77.334035,
      ' 0- 4-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      14,
      ' 0-10-1985',
      NULL,
      NULL,
      8.257016,
      NULL,
      1.827478,
      13.173673,
      '10-29-1983',
      NULL,
      NULL,
      4.584632,
      28,
      ' 2- 8-1986',
      52.118847,
      1.436986,
      35.831106,
      ' 6-17-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


