set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      '0',
      NULL,
      '0',
      '2',
      '2',
      '1',
      NULL,
      '4',
      '1',
      '1',
      '3',
      '0',
      '4',
      '4',
      '1',
      '0',
      '4',
      '4',
      NULL,
      '4',
      NULL,
      '2',
      '',
      '3',
      '',
      '2',
      NULL,
      NULL,
      '2',
      '4',
      '',
      NULL,
      '4',
      NULL,
      '4',
      '4',
      NULL,
      '2',
      NULL,
      '4',
      '3',
      '2',
      '1',
      '341',
      '41',
      4.847127,
      43,
      '2422114',
      2,
      143.278798,
      1,
      NULL,
      '104412',
      5,
      NULL,
      ' 4-21-2002',
      NULL,
      6,
      NULL,
      3.146623,
      5.604557,
      22.933838,
      17,
      3,
      NULL,
      NULL,
      8,
      14.254343,
      40.046618,
      17.784018,
      13.191320,
      11,
      NULL,
      9,
      15,
      10.723216,
      NULL,
      16.787956,
      57.121050,
      NULL,
      NULL,
      29.236373,
      12.768166,
      37.884977,
      35,
      65,
      47,
      NULL,
      59.710982,
      2.590575,
      23.551275,
      25.957455,
      109.912655,
      139.265305,
      '11- 7-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      35.226247,
      10,
      6,
      10.179581,
      0.209432,
      ' 5-28-1986',
      NULL,
      NULL,
      NULL,
      0.253544,
      2,
      76,
      1.365975,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-27-2002',
      78,
      66.972893,
      102.188868,
      100.996530,
      68.176591,
      92.965744,
      9,
      57.563909,
      108.031637,
      NULL,
      80.072732,
      20.385672,
      ' 1-23-1998',
      20,
      21,
      8.302269,
      69,
      42,
      74,
      7.816503,
      ' 7-13-1975',
      6,
      1,
      ' 8- 5-1979',
      0.364086,
      9.366227,
      11.657676,
      1.100170,
      8,
      NULL,
      0,
      5.041977,
      1,
      NULL,
      3.607127,
      5.229333,
      1.939834,
      NULL,
      3.019311,
      3.095153,
      11,
      6.204856,
      ' 9-11-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      61.169863,
      1.124837,
      ' 6-27-2003',
      NULL,
      NULL,
      NULL,
      48,
      ' 7-12-1993',
      32.340565,
      ' 5-22-1980',
      NULL,
      2,
      ' 9- 3-1980',
      66,
      20,
      ' 8-22-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      13.201586,
      ' 1-11-1975',
      NULL,
      14,
      42,
      '11- 9-1994',
      1.152320,
      NULL,
      '10-12-1988',
      1,
      42.701738,
      12.831223,
      0,
      '11-20-1975',
      6,
      1,
      5.242216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


