set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      '1',
      NULL,
      '3',
      '0',
      '3',
      '2',
      '2',
      '2',
      '1',
      '4',
      NULL,
      '0',
      '3',
      NULL,
      '4',
      '2',
      '1',
      '1',
      '2',
      '4',
      '3',
      '',
      '1',
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      '2',
      '',
      '',
      '1',
      '4',
      '4',
      NULL,
      '1',
      '0',
      '2',
      '0',
      '1',
      NULL,
      NULL,
      '303',
      NULL,
      6,
      21.530715,
      NULL,
      0.717168,
      8.210402,
      NULL,
      1,
      '311423',
      NULL,
      ' 5-29-1983',
      ' 7- 0-1998',
      66,
      235.868877,
      28,
      NULL,
      28,
      21,
      20.574063,
      9.431382,
      8.400964,
      6.053119,
      9.103555,
      0.214855,
      34,
      7.890966,
      30.704990,
      17.070461,
      NULL,
      11.392649,
      61.095275,
      9.342770,
      11.045945,
      NULL,
      3,
      0,
      0,
      10.616366,
      99.141435,
      42.100668,
      NULL,
      62.293387,
      137,
      '10- 8-1988',
      52,
      3.807418,
      6,
      24.856103,
      151.118343,
      205.666771,
      ' 2-11-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      70,
      10.387564,
      1.814671,
      6.538352,
      10,
      10,
      ' 0- 0-1988',
      NULL,
      1,
      111,
      0,
      2,
      32,
      1.202902,
      NULL,
      68.284692,
      NULL,
      NULL,
      NULL,
      '10- 3-1978',
      9,
      NULL,
      10.630799,
      40,
      NULL,
      25,
      NULL,
      83,
      35,
      34.370538,
      NULL,
      NULL,
      ' 8-23-1992',
      NULL,
      13,
      13,
      40,
      48.512954,
      47.102398,
      0.859220,
      NULL,
      8,
      0,
      '10-20-1995',
      10,
      15,
      8.751955,
      13.106889,
      13.676748,
      5,
      0,
      9.286539,
      1,
      56.117549,
      NULL,
      1,
      6.747176,
      22,
      3.238888,
      2.065842,
      NULL,
      1.809819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      70,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-23-1975',
      30,
      '11-15-1989',
      8.279793,
      12,
      ' 4-11-1974',
      11.494355,
      34,
      ' 8-26-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      14,
      ' 6-12-1989',
      51.412651,
      37,
      15.529345,
      ' 0- 9-1979',
      1.059059,
      175,
      '10- 5-1993',
      12.129065,
      19,
      11.457948,
      33,
      ' 8-19-1974',
      NULL,
      1.542635,
      181.987866,
      '10- 7-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


