set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      NULL,
      '2',
      '0',
      NULL,
      '1',
      '1',
      '4',
      '4',
      '2',
      '4',
      '2',
      '3',
      '0',
      '0',
      NULL,
      '0',
      '2',
      '0',
      '1',
      NULL,
      '4',
      '1',
      '',
      NULL,
      '',
      '3',
      '3',
      NULL,
      '2',
      '3',
      '',
      NULL,
      NULL,
      '3',
      '4',
      '4',
      '1',
      '1',
      '1',
      '3',
      '1',
      '2',
      '0',
      '344',
      '01311201',
      61.952872,
      43.044172,
      '2124343',
      2.296281,
      167.214242,
      NULL,
      0,
      '113321',
      1,
      ' 2-11-1990',
      ' 2-24-1988',
      85,
      17,
      33,
      2.068531,
      14.064698,
      10.281919,
      NULL,
      11.028443,
      NULL,
      1,
      26,
      13,
      1.295269,
      NULL,
      27,
      1,
      1,
      5,
      14.690190,
      1,
      7,
      2,
      77,
      NULL,
      1,
      10.774362,
      41,
      NULL,
      150.290835,
      NULL,
      NULL,
      NULL,
      34.536980,
      8.317922,
      7,
      22,
      13.076408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      93,
      10,
      4.437783,
      0.723981,
      5,
      3.396316,
      ' 5-20-1984',
      NULL,
      0.273795,
      NULL,
      0.042116,
      NULL,
      NULL,
      1.660495,
      0,
      84.825085,
      NULL,
      NULL,
      NULL,
      ' 3-27-1983',
      NULL,
      8.506654,
      66,
      NULL,
      15.353389,
      49.416435,
      72,
      69.839888,
      NULL,
      26,
      11,
      2,
      ' 7- 9-1992',
      26,
      16.871935,
      24,
      67,
      66.186350,
      5,
      3.048429,
      '11-13-1981',
      NULL,
      4.887728,
      ' 1- 5-1976',
      NULL,
      19,
      4,
      NULL,
      10.853169,
      11,
      0.687254,
      NULL,
      0,
      69.892429,
      1,
      NULL,
      14,
      NULL,
      1.173194,
      NULL,
      1.921087,
      0,
      '11-18-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      18.527961,
      3.607233,
      ' 1-13-1992',
      NULL,
      NULL,
      NULL,
      55.185248,
      ' 8-29-2002',
      12,
      ' 2-24-1999',
      3,
      6,
      NULL,
      NULL,
      75,
      ' 6-14-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      ' 5-11-1995',
      39,
      37.135470,
      3.163246,
      NULL,
      1.773972,
      8.162034,
      NULL,
      NULL,
      11.380837,
      14.332673,
      NULL,
      ' 4- 4-1983',
      12.213376,
      0.008633,
      75.154118,
      ' 6- 7-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


