set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228028';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0434',
      '22004324',
      NULL,
      '02341403',
      NULL,
      '31214322',
      '23421334',
      NULL,
      '22111121',
      NULL,
      '10322224',
      '32101102',
      '43023122',
      '03102141',
      '11222111',
      NULL,
      '00433203',
      '30201231',
      '11013413',
      NULL,
      '04032004',
      '31031210',
      '20242124',
      '33413024',
      '21323124',
      '43002422',
      '24231344',
      '02201022',
      '22343033',
      '14043122',
      '23011204',
      NULL,
      NULL,
      '11113401',
      '22422310',
      '01003344',
      '40132404',
      '31313120',
      NULL,
      '40004032',
      '44301320',
      '04142423',
      '03424414',
      '34013434',
      '23411133',
      '221',
      '04',
      NULL,
      NULL,
      '1234342',
      2,
      0,
      2,
      NULL,
      '104241',
      2,
      NULL,
      ' 5-10-1989',
      57.286454,
      NULL,
      25,
      16.979230,
      NULL,
      1.644407,
      87,
      17.463756,
      13.420325,
      20.038042,
      41,
      15.604658,
      NULL,
      5.307656,
      NULL,
      NULL,
      NULL,
      17.025783,
      66,
      NULL,
      37,
      23,
      140,
      NULL,
      1.486430,
      86,
      NULL,
      125,
      35.503925,
      70,
      NULL,
      '10-13-1991',
      26,
      11,
      19.041275,
      21.696006,
      196.779391,
      178,
      ' 1- 6-1998',
      NULL,
      4,
      NULL,
      1,
      1,
      0.053427,
      1.808160,
      0.429041,
      NULL,
      0,
      3.682420,
      0.642330,
      1.109171,
      NULL,
      0.533092,
      NULL,
      3.684310,
      NULL,
      1.552343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 7-1987',
      35.085270,
      2,
      12.451274,
      7,
      10,
      NULL,
      NULL,
      3,
      1.963043,
      20.760476,
      0,
      0.093337,
      58.200522,
      0.107369,
      1.902633,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 8-1996',
      31.103303,
      63.349930,
      30.906203,
      4.208850,
      4,
      27,
      79.255864,
      9.185887,
      NULL,
      53.316718,
      12,
      80,
      ' 1-28-1979',
      24.664126,
      NULL,
      4,
      NULL,
      NULL,
      26.197985,
      2,
      ' 1-29-1982',
      9,
      9,
      ' 8-12-1979',
      1.682465,
      NULL,
      9,
      27.985157,
      25.519538,
      3,
      0,
      26.259401,
      1,
      NULL,
      NULL,
      0.459744,
      29,
      NULL,
      3.140760,
      0.044297,
      NULL,
      1.586437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      231,
      0.446779,
      ' 5-27-1995',
      NULL,
      NULL,
      NULL,
      1.005989,
      NULL,
      NULL,
      ' 7- 2-1977',
      3.502797,
      8.501333,
      '10-23-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 0-19-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      10.222382,
      NULL,
      59.507565,
      30,
      NULL,
      NULL,
      0,
      110,
      ' 8-12-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


