set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9826038';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      '3',
      '1',
      '1',
      '1',
      '1',
      NULL,
      '1',
      '0',
      '1',
      NULL,
      '1',
      '0',
      '3',
      '0',
      '2',
      '3',
      '',
      '0',
      '',
      NULL,
      '2',
      '4',
      '4',
      NULL,
      NULL,
      '',
      '0',
      NULL,
      '2',
      '1',
      '1',
      '0',
      '4',
      '4',
      '0',
      '1',
      '4',
      '211',
      '13334440',
      NULL,
      18.261667,
      '0020230',
      0,
      1.622863,
      1,
      NULL,
      NULL,
      2.861674,
      ' 2-25-1990',
      ' 0- 9-1982',
      33.224220,
      170.868013,
      23.644396,
      17.023474,
      3.081153,
      3,
      13.553446,
      NULL,
      22,
      2.117982,
      10,
      NULL,
      11.067716,
      7.223482,
      17,
      7,
      27.792206,
      5,
      87,
      5.971866,
      21,
      3,
      23,
      6,
      0.276308,
      68,
      12.680307,
      14.220388,
      28,
      NULL,
      131,
      ' 8- 3-1999',
      NULL,
      3.427225,
      NULL,
      2,
      NULL,
      180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37.445053,
      17,
      NULL,
      5,
      5,
      NULL,
      1,
      0,
      190.241579,
      1.105256,
      NULL,
      51,
      0,
      3,
      89.774976,
      NULL,
      NULL,
      NULL,
      ' 3- 4-1995',
      5.769370,
      26,
      31,
      63,
      NULL,
      52.095817,
      30,
      69,
      62.113332,
      62.763070,
      NULL,
      12.753483,
      ' 1- 2-1987',
      13,
      4.709088,
      9.037610,
      8.748798,
      NULL,
      NULL,
      7.528735,
      NULL,
      NULL,
      14.847351,
      ' 0-24-1997',
      13,
      NULL,
      0.740186,
      NULL,
      14,
      NULL,
      1.455491,
      8,
      NULL,
      NULL,
      0.710350,
      0.813409,
      NULL,
      NULL,
      0,
      0,
      0.121573,
      1,
      ' 5-20-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      137,
      1.138980,
      ' 6-13-1989',
      NULL,
      NULL,
      NULL,
      3,
      ' 0-29-1983',
      16.077156,
      ' 1-14-1977',
      0.398808,
      4,
      ' 1-24-1993',
      44.012557,
      107,
      ' 2-23-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      ' 4- 8-2003',
      41.238939,
      9.135608,
      18.555008,
      ' 2-25-1979',
      0.672918,
      61,
      ' 8-20-1994',
      4.371606,
      NULL,
      0,
      51.060081,
      NULL,
      8.236479,
      1.486386,
      65.671305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


