set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9826038';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      '1',
      '1',
      '4',
      '4',
      '0',
      '2',
      NULL,
      '3',
      '2',
      '4',
      NULL,
      '4',
      '3',
      '0',
      NULL,
      '3',
      '3',
      '4',
      NULL,
      '2',
      '1',
      NULL,
      '',
      '2',
      '',
      '2',
      '3',
      '0',
      '2',
      '1',
      '',
      '',
      '4',
      '2',
      '0',
      '3',
      '3',
      '0',
      '4',
      '2',
      NULL,
      '2',
      NULL,
      '344',
      '02433002',
      NULL,
      39.501303,
      '0001312',
      1,
      44,
      2,
      0,
      '201234',
      4,
      NULL,
      NULL,
      240.183746,
      70,
      13,
      NULL,
      1,
      11.187398,
      NULL,
      7.766298,
      17,
      3.639389,
      8,
      9,
      17.176254,
      11,
      17.796410,
      10,
      4.822544,
      17,
      25.570114,
      NULL,
      NULL,
      5,
      63.159200,
      16,
      NULL,
      78,
      141.238858,
      NULL,
      48,
      NULL,
      56,
      NULL,
      45,
      0.356338,
      11.520388,
      NULL,
      41,
      140,
      '10-29-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.694658,
      19,
      NULL,
      6,
      1,
      NULL,
      0,
      1,
      86,
      0.492402,
      4,
      NULL,
      3,
      0.922595,
      52.298733,
      NULL,
      NULL,
      NULL,
      ' 4- 4-1999',
      95.417019,
      79,
      NULL,
      17,
      NULL,
      NULL,
      17.544771,
      36,
      38.468422,
      NULL,
      47.591323,
      NULL,
      ' 8-29-1990',
      40,
      NULL,
      5.372842,
      NULL,
      44,
      NULL,
      2.043772,
      ' 8- 9-2000',
      16,
      4,
      ' 2-17-1995',
      6.140304,
      3.305751,
      NULL,
      NULL,
      20.959859,
      0.514184,
      6,
      NULL,
      NULL,
      69,
      13.727985,
      2,
      5,
      18.104619,
      2,
      1,
      1.119070,
      2.622920,
      ' 7-19-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      102.266567,
      19,
      ' 9-22-1975',
      NULL,
      NULL,
      NULL,
      32.625549,
      '11- 8-1984',
      7.751837,
      ' 0-18-1978',
      10,
      4,
      NULL,
      NULL,
      NULL,
      ' 2-15-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      17,
      ' 0-24-1992',
      NULL,
      3,
      NULL,
      ' 5- 6-1992',
      0,
      20.684218,
      NULL,
      NULL,
      7,
      22.700253,
      25.764368,
      ' 2- 6-2001',
      NULL,
      NULL,
      NULL,
      ' 2- 3-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


