set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9678720';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3442',
      '31302421',
      '24020313',
      '10000232',
      '30324122',
      '00123341',
      '20403411',
      '02130432',
      NULL,
      NULL,
      '20000334',
      NULL,
      NULL,
      '20040420',
      NULL,
      '00011134',
      '22101032',
      '44243442',
      '31312201',
      '32340123',
      '33121203',
      '03144313',
      '02222010',
      NULL,
      '23200434',
      NULL,
      NULL,
      '02000011',
      '32110232',
      '13242323',
      '04113230',
      NULL,
      '31024211',
      '03231211',
      '10403032',
      '41332101',
      '24303012',
      '44101333',
      '03244033',
      '13203341',
      NULL,
      NULL,
      '31020300',
      '43022134',
      '01234024',
      '414',
      '32',
      13.960256,
      21.191045,
      '1300132',
      1,
      1,
      NULL,
      NULL,
      '043143',
      5,
      '11- 0-1981',
      ' 9-16-1983',
      NULL,
      97,
      6,
      10,
      13.578186,
      NULL,
      41,
      6,
      12,
      9.453969,
      26,
      16,
      13.677352,
      0.181559,
      9.704352,
      3.286547,
      15,
      8.310523,
      41.612810,
      5.836172,
      69.460520,
      NULL,
      45.584485,
      15,
      1.822659,
      NULL,
      31,
      44.220704,
      219,
      188,
      112.609066,
      '10-10-1980',
      13,
      NULL,
      25,
      25,
      118,
      106.993839,
      ' 0-28-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      92.713312,
      NULL,
      13,
      5,
      1,
      2.246590,
      ' 8-23-1974',
      1.211791,
      1,
      65.958095,
      1.018198,
      0,
      112,
      1.313997,
      2,
      44.401984,
      NULL,
      NULL,
      NULL,
      ' 8- 0-1996',
      33,
      69,
      NULL,
      39,
      80.267963,
      13,
      72.943405,
      16.090311,
      66,
      14.771367,
      26.492344,
      48,
      ' 3-15-1990',
      15.379746,
      13.588782,
      5,
      4.135257,
      64,
      49,
      4,
      NULL,
      11,
      10,
      ' 7- 9-1999',
      1.239368,
      8.145959,
      NULL,
      5,
      11,
      11.016653,
      0.878582,
      15,
      1.483840,
      NULL,
      2.022659,
      1.806574,
      4.547052,
      23.785220,
      1,
      NULL,
      0,
      3,
      ' 9- 0-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      48,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      ' 1-26-1982',
      26,
      ' 8- 8-1993',
      NULL,
      13,
      ' 3-14-1974',
      10,
      19,
      ' 3- 1-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      9.228405,
      ' 3-21-1984',
      NULL,
      44,
      27.903027,
      ' 4-12-2001',
      1.640121,
      56.840673,
      NULL,
      NULL,
      NULL,
      NULL,
      48,
      ' 5- 1-1983',
      NULL,
      1,
      77,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


