set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9678720';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '3',
      '3',
      '4',
      '2',
      '2',
      '3',
      '2',
      '3',
      '2',
      NULL,
      '1',
      '3',
      NULL,
      '3',
      '2',
      '0',
      '1',
      NULL,
      '3',
      '0',
      '1',
      '1',
      '',
      NULL,
      '',
      NULL,
      '3',
      '0',
      '0',
      '0',
      '',
      '',
      '3',
      '1',
      '4',
      '2',
      '2',
      NULL,
      '0',
      '2',
      '3',
      '1',
      '0',
      '043',
      '44012202',
      28.643499,
      10,
      NULL,
      2.350645,
      44,
      2,
      NULL,
      '002213',
      4.755918,
      NULL,
      ' 3-16-1982',
      94,
      60,
      3.539725,
      1,
      18.606908,
      NULL,
      51.275522,
      13,
      NULL,
      14.633085,
      12.399029,
      11.476755,
      23.550603,
      6,
      31.192778,
      NULL,
      17,
      23.694722,
      NULL,
      23,
      60.589773,
      24.438620,
      112,
      0.624394,
      1.406430,
      18.088617,
      68,
      NULL,
      183,
      186.004973,
      147.365755,
      NULL,
      44,
      NULL,
      28.024170,
      20,
      78,
      31,
      ' 8-23-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      19.449064,
      9.933648,
      8.531651,
      1,
      1,
      ' 9- 9-2000',
      1.860552,
      NULL,
      NULL,
      NULL,
      NULL,
      112,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      ' 8-13-1994',
      49,
      4,
      54,
      NULL,
      42,
      60.543660,
      14.097540,
      70.078276,
      41,
      62,
      NULL,
      40.159959,
      ' 8-13-1983',
      NULL,
      NULL,
      11,
      13,
      30.411736,
      22.704682,
      NULL,
      NULL,
      7.629023,
      9,
      '10-17-1987',
      3.513433,
      2,
      8,
      3,
      2.985196,
      6,
      0.576330,
      18,
      0,
      83,
      1,
      1.577717,
      19.886888,
      1.557040,
      5.276862,
      0.115685,
      1.384324,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7.425632,
      ' 9-15-1982',
      9,
      ' 9-12-1992',
      0.247527,
      NULL,
      ' 0-14-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      22.877238,
      NULL,
      37,
      NULL,
      22,
      ' 8-15-1990',
      0,
      33.824595,
      ' 9- 9-1980',
      9.023412,
      27.331973,
      8.489158,
      3,
      ' 7-19-1993',
      40.289483,
      NULL,
      83.627804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


