set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9698051';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '1',
      '2',
      NULL,
      '3',
      '1',
      '4',
      '2',
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      '4',
      '4',
      '4',
      NULL,
      '2',
      '3',
      '4',
      NULL,
      '0',
      '3',
      '3',
      NULL,
      '1',
      '',
      '3',
      '3',
      '2',
      '1',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '1',
      '3',
      '1',
      '2',
      '3',
      '0',
      '1',
      '0',
      '2',
      '434',
      '23213003',
      NULL,
      57,
      '3400200',
      2,
      88,
      1,
      NULL,
      '231332',
      5,
      '10-29-1979',
      ' 6-14-1975',
      128.802073,
      44.132868,
      2.363344,
      0,
      15,
      NULL,
      21.701628,
      3,
      2.621381,
      2.805900,
      NULL,
      NULL,
      1,
      2.265573,
      2,
      2,
      11,
      9,
      2,
      5,
      18,
      NULL,
      25,
      NULL,
      0.448878,
      15.303253,
      51,
      NULL,
      116.017574,
      85,
      29.914289,
      ' 3- 2-1998',
      41.919997,
      17,
      3.701202,
      19,
      NULL,
      113,
      ' 7-26-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      34.378220,
      77.579032,
      8.673179,
      NULL,
      11.104069,
      0.529404,
      '10-28-1991',
      NULL,
      0.165641,
      NULL,
      6.558799,
      0.292991,
      58.719217,
      1,
      1.299074,
      12.946727,
      NULL,
      NULL,
      NULL,
      ' 9-19-1974',
      14.595017,
      20.852321,
      31,
      15,
      18.167997,
      26.630944,
      12.226557,
      37,
      0,
      NULL,
      5,
      10,
      ' 6-10-1976',
      4.507674,
      NULL,
      4,
      23,
      27.537422,
      0,
      NULL,
      ' 4-21-1990',
      NULL,
      2,
      ' 8- 1-2003',
      3.586199,
      8.167317,
      NULL,
      7,
      NULL,
      NULL,
      1,
      1,
      0.943437,
      19.783655,
      9,
      0,
      0.071667,
      13,
      14,
      9,
      NULL,
      9.543759,
      ' 5- 8-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.227380,
      ' 1-24-1974',
      31.530511,
      ' 8- 2-2002',
      6,
      10,
      ' 8-16-1997',
      NULL,
      52,
      '10-23-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      12,
      ' 0- 2-1983',
      10,
      0,
      NULL,
      ' 9- 8-1979',
      NULL,
      NULL,
      NULL,
      0,
      90.498617,
      7.834659,
      23.010130,
      ' 5- 1-1975',
      NULL,
      1.865071,
      75,
      ' 1- 3-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


