set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9334584';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '41443304',
      '22022211',
      '23341431',
      '30014212',
      '31142123',
      '11230422',
      '30110104',
      '40042004',
      '11104041',
      '03024312',
      '12413441',
      NULL,
      '24303330',
      '22122404',
      '00103411',
      '13302222',
      '24314144',
      NULL,
      '00440010',
      '30122233',
      '44223342',
      NULL,
      '24420300',
      NULL,
      '11223002',
      '42231134',
      '43420213',
      '22134100',
      '10240434',
      '30040212',
      '24410140',
      '33033244',
      '30031330',
      '34023413',
      '33142422',
      '04222432',
      '34340330',
      NULL,
      '03300010',
      '01434242',
      '30344302',
      '14030341',
      '34112422',
      '24042414',
      '443',
      '12',
      31,
      3,
      '1110344',
      3,
      0.813540,
      3,
      NULL,
      '020323',
      0,
      ' 2-21-1991',
      ' 9- 3-1994',
      66,
      92,
      19.626222,
      23.620302,
      21,
      10,
      69,
      NULL,
      NULL,
      18.212883,
      8.871502,
      6.737650,
      NULL,
      5,
      NULL,
      1,
      24,
      0,
      43,
      3,
      11.333858,
      NULL,
      125.198535,
      27,
      1,
      3.683445,
      89,
      22.027425,
      132.737142,
      78,
      131,
      '11-13-1991',
      24,
      48,
      NULL,
      30,
      42.925267,
      NULL,
      ' 9-22-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      29,
      NULL,
      9,
      15,
      7,
      NULL,
      1,
      1.743565,
      72.854899,
      NULL,
      0,
      NULL,
      0.144326,
      NULL,
      30.595159,
      NULL,
      NULL,
      NULL,
      '10-24-1995',
      53,
      NULL,
      20.547806,
      NULL,
      16,
      10,
      93,
      10.486967,
      2.573634,
      29.489860,
      55.591774,
      NULL,
      '11-20-1996',
      23.245699,
      16,
      28.199030,
      NULL,
      88.072181,
      36.221512,
      6.770190,
      ' 0-20-1982',
      8,
      8.473047,
      NULL,
      10,
      13.570311,
      NULL,
      22.790080,
      NULL,
      11.212826,
      1.088952,
      21,
      1.607569,
      28.730431,
      0,
      1,
      2.036292,
      1.964749,
      1.686227,
      1.195349,
      1,
      1.937315,
      ' 8-22-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      305,
      1.542428,
      ' 9-12-1974',
      NULL,
      NULL,
      NULL,
      53,
      '10- 0-1994',
      NULL,
      ' 4-26-1982',
      10,
      3.394776,
      ' 1-21-1998',
      116.790172,
      NULL,
      ' 6-13-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      11,
      ' 8-24-1990',
      6.896942,
      27,
      2,
      ' 3- 2-1986',
      0,
      NULL,
      ' 6- 3-1986',
      10,
      53.954537,
      8,
      50,
      ' 3-13-1981',
      8,
      0,
      39,
      '10- 3-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


