set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7603326';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1240',
      '24343240',
      NULL,
      '31023242',
      '31421043',
      NULL,
      '11443303',
      '30333442',
      '11234244',
      '41233011',
      '21002034',
      '02043203',
      '42120133',
      '40241104',
      '00302144',
      '31023030',
      NULL,
      '01241441',
      '31303204',
      '44004034',
      NULL,
      '11043420',
      '01000404',
      NULL,
      '11401111',
      '13244142',
      NULL,
      NULL,
      '24210132',
      '21441200',
      '24011211',
      '44200233',
      '20444112',
      '43132014',
      '12010210',
      '03221311',
      '42434312',
      '44340001',
      '21233344',
      NULL,
      '21443143',
      '23303333',
      NULL,
      '44204413',
      '33402204',
      '004',
      '01',
      NULL,
      NULL,
      '3421242',
      1.444605,
      NULL,
      0,
      NULL,
      '434421',
      5.754647,
      ' 9- 7-1988',
      NULL,
      68.822265,
      NULL,
      NULL,
      0.594435,
      20,
      7,
      11.916240,
      5.146543,
      8,
      4,
      12.402791,
      2.710741,
      4,
      2,
      14,
      7.009244,
      4.733644,
      9,
      9.563707,
      1.728097,
      13,
      0.103208,
      NULL,
      3,
      NULL,
      NULL,
      80.952379,
      25.435269,
      133.568958,
      15,
      120,
      ' 3- 9-1985',
      4.635480,
      NULL,
      3.208840,
      13.424329,
      144.241266,
      100,
      ' 8- 3-1979',
      5,
      37.696314,
      1.550131,
      NULL,
      NULL,
      4.024732,
      0,
      3.860611,
      1,
      NULL,
      33,
      1.531869,
      1.379860,
      NULL,
      1.452565,
      1,
      16,
      0,
      0.131252,
      2.061978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23.908394,
      12.175212,
      106.781617,
      13.939284,
      4,
      NULL,
      NULL,
      0.375482,
      1,
      108.902442,
      0,
      1,
      24.697151,
      1,
      NULL,
      20,
      0,
      0.612900,
      61,
      ' 1- 3-1989',
      4.555260,
      22.469310,
      NULL,
      63,
      25.869875,
      NULL,
      77,
      48.995884,
      56,
      3,
      NULL,
      62.948446,
      ' 3- 9-1978',
      7,
      22.739100,
      1,
      NULL,
      NULL,
      17,
      NULL,
      '11-24-1998',
      10.010841,
      3,
      NULL,
      NULL,
      9.280817,
      NULL,
      11.359097,
      12.503471,
      5,
      NULL,
      NULL,
      NULL,
      74,
      8.773745,
      NULL,
      2,
      4.484104,
      4.465686,
      NULL,
      0,
      1.669741,
      ' 9-28-1989',
      0.266213,
      0.698313,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.836537,
      ' 8-27-1975',
      NULL,
      ' 9- 9-1987',
      11.355834,
      NULL,
      ' 3-13-1998',
      NULL,
      NULL,
      NULL,
      1,
      2.884376,
      '10-29-1996',
      NULL,
      3.771583,
      ' 4-11-1975',
      NULL,
      0,
      11,
      ' 4- 9-1994',
      NULL,
      4,
      16.764681,
      ' 1-18-1987',
      0,
      342.378082,
      ' 7-25-1975',
      NULL,
      4.992761,
      9.295794,
      52.752886,
      NULL,
      34,
      0,
      69,
      ' 4-24-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.161706);
commit;
end;
/


