set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8607971';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3020',
      '34110301',
      '04210444',
      NULL,
      '23144342',
      '10034222',
      '21130314',
      '00341214',
      NULL,
      '14232111',
      '44114032',
      '42223240',
      '12123412',
      '44400322',
      '43240141',
      NULL,
      '10243114',
      '32200124',
      '04324033',
      '20143004',
      '22111421',
      '00033142',
      '14041343',
      '12010100',
      '04420441',
      '44402243',
      '33114411',
      '33133424',
      NULL,
      '34244410',
      NULL,
      NULL,
      '14342134',
      '14024103',
      '44043040',
      '30143113',
      NULL,
      '14113430',
      '41444102',
      '30304002',
      '03002301',
      '21022221',
      NULL,
      '14133012',
      '43111402',
      '',
      NULL,
      NULL,
      NULL,
      '4330332',
      1.127962,
      0.297556,
      1,
      NULL,
      '100144',
      2.343645,
      NULL,
      NULL,
      34,
      NULL,
      33,
      19.519558,
      NULL,
      7,
      81,
      19.602722,
      NULL,
      5.674752,
      7,
      2,
      38.440162,
      NULL,
      8.109370,
      16,
      29.915033,
      12.119456,
      17.084034,
      9,
      37,
      9.808481,
      NULL,
      NULL,
      NULL,
      79.107575,
      133.611930,
      NULL,
      59.723447,
      117,
      91,
      '11-12-1989',
      19.039437,
      16,
      28,
      3.036767,
      186.319268,
      55.959707,
      ' 3-18-1990',
      0,
      0,
      NULL,
      0.417477,
      NULL,
      NULL,
      NULL,
      NULL,
      1.991377,
      1,
      2.307031,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-11-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-22-1984',
      47.009021,
      42.314522,
      NULL,
      10,
      NULL,
      103.586429,
      119.586047,
      53,
      50.514365,
      12,
      13.677030,
      8.920038,
      ' 3- 2-1990',
      14.775585,
      22,
      12.792507,
      7.762226,
      66.931893,
      134,
      NULL,
      NULL,
      NULL,
      18.184209,
      NULL,
      15,
      14.767398,
      NULL,
      19.677348,
      31.064704,
      7.341383,
      NULL,
      18,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-19-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      55,
      20.811550,
      NULL,
      0,
      78,
      NULL,
      10,
      7.934825,
      13.025047,
      32,
      ' 9-18-1977',
      53,
      1.049455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      NULL,
      0,
      18,
      12.331602,
      93,
      32.722659,
      4,
      1,
      0.712185,
      2,
      47,
      0.456490,
      1.462014,
      23.014691,
      2,
      0,
      2,
      7.901492,
      3,
      72,
      0,
      1.334329,
      108,
      45.903279,
      6,
      NULL,
      NULL,
      53.266690,
      1.288122,
      0,
      0.772588,
      NULL,
      1.467791,
      NULL,
      50,
      44.211892,
      14,
      8,
      46,
      NULL,
      3,
      0.379977,
      12.492011,
      0.921259,
      0,
      NULL,
      24,
      1.024611,
      40,
      0,
      NULL,
      0,
      4.554408,
      NULL,
      33,
      10.283716,
      NULL,
      17,
      51,
      8.558881,
      NULL,
      9.830057,
      4,
      1.471627,
      1.444090,
      1.390833,
      1.031938,
      0.863315,
      0.821877,
      66.059898,
      '10-26-1991',
      ' 0-21-2000',
      ' 6-13-2001',
      NULL,
      NULL,
      ' 3- 3-2003',
      ' 2- 2-1982',
      NULL);
commit;
end;
/


