set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8607971';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3031',
      '41134043',
      '42333224',
      '41432122',
      '30222110',
      '31102413',
      '30444403',
      '11203231',
      NULL,
      NULL,
      '42221001',
      '13320144',
      '24331424',
      '40311214',
      '14413041',
      NULL,
      '01341002',
      NULL,
      '34122114',
      '30002301',
      NULL,
      '11221223',
      '32024043',
      NULL,
      NULL,
      '30431234',
      '30103030',
      '01402232',
      '11111431',
      NULL,
      NULL,
      '34111344',
      '41121044',
      '12234123',
      NULL,
      '01244113',
      '02101130',
      '11224342',
      NULL,
      '34344112',
      '41131444',
      '24441024',
      '42304423',
      NULL,
      '12224110',
      '',
      '',
      NULL,
      NULL,
      '1240204',
      0.910419,
      3,
      NULL,
      NULL,
      '123213',
      1,
      ' 9-26-1981',
      ' 6- 9-1998',
      43,
      NULL,
      15,
      NULL,
      27.148016,
      NULL,
      95,
      6.465448,
      5.573092,
      NULL,
      7.211805,
      0,
      37,
      5.081154,
      15,
      9,
      32.141865,
      2,
      NULL,
      10.878177,
      NULL,
      9.194859,
      43.753599,
      12.140708,
      NULL,
      57,
      50.349985,
      NULL,
      NULL,
      71.002976,
      NULL,
      ' 0-21-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.251932,
      1.663652,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.502090,
      0.193837,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-26-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 8-1996',
      18,
      NULL,
      NULL,
      74,
      59,
      147,
      28,
      90.350310,
      NULL,
      NULL,
      109.813783,
      124,
      NULL,
      15.883590,
      31,
      NULL,
      NULL,
      NULL,
      61,
      10.876850,
      NULL,
      23.389597,
      4,
      ' 5- 9-1978',
      8,
      7.456354,
      20.381061,
      17.289654,
      15,
      4,
      NULL,
      22.208947,
      NULL,
      45,
      5.433406,
      9.655880,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-19-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      48.597284,
      28.717440,
      62,
      '10- 4-1994',
      4.696457,
      NULL,
      ' 4-10-1992',
      5,
      11.478246,
      2,
      4,
      '11-23-1990',
      58.215721,
      1,
      63,
      ' 1-25-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.691265,
      NULL,
      45.185371,
      137,
      NULL,
      0,
      3,
      1.633816,
      NULL,
      62.831394,
      0,
      1,
      48.083428,
      NULL,
      3.349931,
      54,
      1.573451,
      3,
      NULL,
      NULL,
      NULL,
      43,
      28.766066,
      NULL,
      0,
      0.220352,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.361515,
      0,
      26.071780,
      39.993015,
      19,
      NULL,
      48,
      16,
      1,
      3.533370,
      14.095757,
      1.975747,
      1.450339,
      1.489639,
      41.904544,
      1,
      63,
      0,
      11,
      0.032868,
      NULL,
      56.819853,
      34,
      NULL,
      30.351445,
      27.567826,
      58.893581,
      4,
      51,
      11,
      0.062249,
      0.880798,
      0,
      0.200537,
      0.924978,
      0.132001,
      1,
      61.080814,
      ' 7-26-1987',
      '10-19-1977',
      ' 9- 3-1984',
      ' 6- 9-1983',
      NULL,
      ' 0- 8-1978',
      '11- 2-1994',
      NULL);
commit;
end;
/


