set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9768908';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      '2',
      '0',
      '2',
      '2',
      '0',
      '2',
      '0',
      '0',
      NULL,
      NULL,
      '3',
      '4',
      '4',
      '0',
      '4',
      NULL,
      '3',
      '2',
      '0',
      '2',
      NULL,
      '2',
      NULL,
      '0',
      '',
      '4',
      '0',
      NULL,
      '3',
      '1',
      NULL,
      '',
      '1',
      '2',
      '2',
      NULL,
      '0',
      '2',
      '3',
      '0',
      '2',
      '0',
      '3',
      '413',
      NULL,
      14.573105,
      20.068786,
      NULL,
      0,
      0.663317,
      1,
      NULL,
      '440322',
      3.153100,
      ' 2-29-1981',
      ' 1- 8-1978',
      69.246251,
      67,
      30,
      20,
      18.308292,
      21.327302,
      92.715708,
      5,
      27.000154,
      15,
      NULL,
      14,
      NULL,
      10.329870,
      34,
      NULL,
      20.998554,
      10.286238,
      61,
      5,
      NULL,
      16.156166,
      NULL,
      7.710853,
      1,
      100.859278,
      171,
      12.905010,
      180.031878,
      NULL,
      NULL,
      ' 0-19-1997',
      35.858629,
      55.530177,
      36,
      15,
      63,
      47,
      ' 6- 5-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      62,
      35,
      23,
      3.924974,
      NULL,
      2,
      '10-28-1997',
      1.911777,
      0,
      221,
      0.027290,
      2.493797,
      161,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-29-1980',
      74.540787,
      26,
      31.785022,
      44.536514,
      28,
      91.603783,
      10,
      79,
      40.605187,
      NULL,
      90,
      48.516803,
      ' 4-22-1981',
      34,
      31.129619,
      20,
      56.510207,
      99.274072,
      154,
      5.094222,
      ' 2- 2-1975',
      21,
      NULL,
      NULL,
      13.066526,
      NULL,
      21.141443,
      4,
      0,
      11,
      0.097782,
      2,
      NULL,
      NULL,
      NULL,
      2,
      15.407673,
      26,
      1.466498,
      1,
      0,
      1.256693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.860052,
      ' 0- 8-1996',
      NULL,
      NULL,
      NULL,
      5,
      ' 8- 1-1997',
      NULL,
      ' 2-25-1975',
      12.085145,
      4.735383,
      NULL,
      13.344886,
      74.248611,
      ' 2-26-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      10.660174,
      '11- 8-1992',
      12,
      52.162876,
      54,
      ' 3-17-2000',
      1,
      41.359033,
      '11-24-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


