set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9627113';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1344',
      '33233012',
      '03123342',
      '40004142',
      '31421302',
      '32400033',
      '13244312',
      '14243000',
      '02430002',
      NULL,
      '10222330',
      NULL,
      '02344232',
      '03042211',
      '31014210',
      '02433400',
      NULL,
      '12401212',
      '30123100',
      '23340200',
      NULL,
      NULL,
      '21142344',
      '24401020',
      '22423101',
      '10203243',
      '14444344',
      '23201040',
      '41342220',
      NULL,
      '12323031',
      '13301102',
      '12442314',
      '11421211',
      '20232002',
      NULL,
      '03441241',
      '30313242',
      '00232111',
      '02321302',
      '24004013',
      '02224412',
      NULL,
      '22112010',
      '33122310',
      '024',
      NULL,
      22.391931,
      8.524429,
      '2134323',
      2,
      0,
      1,
      NULL,
      '304400',
      4.913410,
      ' 8-13-1983',
      '11-21-1994',
      NULL,
      55.444712,
      39,
      6,
      NULL,
      13.641493,
      56,
      NULL,
      NULL,
      24.479572,
      15.009381,
      9,
      11.657917,
      NULL,
      28.389115,
      NULL,
      29.315659,
      7,
      31,
      20.761631,
      11.028093,
      2,
      NULL,
      26.108194,
      1.395752,
      30.614935,
      155.483026,
      43.803433,
      145,
      207.330475,
      159.658502,
      '10- 4-2002',
      44.202009,
      NULL,
      20.358761,
      6,
      149.933992,
      165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      15,
      0.226900,
      2.877886,
      8,
      ' 0- 8-1992',
      1,
      1.729713,
      72.156484,
      NULL,
      0.266504,
      113.290517,
      0,
      1.004793,
      86,
      NULL,
      NULL,
      NULL,
      ' 5- 5-1988',
      NULL,
      79.305905,
      102.677811,
      48,
      99,
      29,
      NULL,
      39,
      28,
      81,
      44,
      10.173146,
      NULL,
      9.346308,
      NULL,
      4.763838,
      NULL,
      59.844098,
      16.114778,
      9.231716,
      ' 8-29-1985',
      31,
      5,
      NULL,
      0.514903,
      16,
      14,
      19,
      28.549005,
      8.941756,
      NULL,
      10,
      0.450300,
      152,
      1.367876,
      1.467347,
      27.581798,
      26,
      3.415773,
      1,
      1,
      0,
      ' 1-14-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.111185,
      ' 3- 5-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 6-1984',
      39,
      ' 2-11-1987',
      4.436701,
      15,
      ' 0-16-1975',
      75.150052,
      84.501888,
      '11-12-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      12,
      ' 6-21-1991',
      49,
      57.114758,
      26,
      ' 5-17-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


