set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8428962';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4001',
      NULL,
      '34034233',
      NULL,
      '44443224',
      '30421443',
      '41324131',
      '33224242',
      '42343012',
      '01001203',
      '14344111',
      '33104200',
      '00440003',
      '32010103',
      '40233103',
      '11403112',
      '44434310',
      '14014114',
      '03001311',
      '22102141',
      '20110010',
      '23110310',
      '04343020',
      '43234001',
      '31243322',
      NULL,
      '31003210',
      '24301433',
      '01310112',
      NULL,
      NULL,
      '42332111',
      '21211321',
      '34242224',
      '40240004',
      '33211242',
      '10001043',
      '12432020',
      '00134344',
      '22222210',
      '14201013',
      '31414324',
      '24222011',
      '22021012',
      '04442001',
      '',
      '',
      NULL,
      NULL,
      '3440041',
      0.315429,
      1.441287,
      3,
      NULL,
      '022444',
      3,
      ' 2- 1-1976',
      ' 3- 9-1987',
      66,
      NULL,
      7,
      NULL,
      6.720657,
      15.688666,
      49,
      8,
      NULL,
      2,
      20.309540,
      11.072917,
      18,
      4.626238,
      9.661912,
      9,
      NULL,
      8.686210,
      NULL,
      16.338054,
      22.306550,
      2,
      66,
      NULL,
      NULL,
      44.730236,
      119.841364,
      40.575178,
      84.001989,
      118,
      72.637750,
      '10- 1-1986',
      NULL,
      28,
      28,
      17.600111,
      NULL,
      179,
      ' 7-14-1991',
      0.902535,
      5,
      NULL,
      1.699432,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      6,
      NULL,
      0.617778,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 1-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-12-2003',
      NULL,
      NULL,
      64,
      105.869968,
      121.309829,
      115,
      48.541890,
      40,
      1,
      48,
      79,
      107,
      NULL,
      24.839121,
      8.157801,
      12.226953,
      44,
      61,
      38.459692,
      4,
      ' 9-27-2003',
      7.977501,
      NULL,
      NULL,
      0,
      0.507124,
      0,
      9,
      14,
      8.148739,
      NULL,
      9.424391,
      NULL,
      67,
      NULL,
      6.885369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-14-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.074583,
      12,
      18.181504,
      ' 1-14-1987',
      NULL,
      6.125951,
      '11-25-1987',
      11,
      7.704013,
      12,
      NULL,
      ' 5-14-1998',
      NULL,
      1.031609,
      60.370213,
      ' 3- 1-1996',
      NULL,
      NULL,
      NULL,
      12,
      16.488633,
      0.168887,
      25,
      40,
      NULL,
      55,
      NULL,
      1.367869,
      36.807181,
      0,
      0,
      3,
      1,
      11.852412,
      0.810399,
      0,
      35,
      3,
      13,
      102.654644,
      0.266489,
      11,
      NULL,
      19.917296,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.008222,
      6,
      1,
      NULL,
      NULL,
      NULL,
      7.929890,
      0.142234,
      27,
      57,
      3.583167,
      1,
      NULL,
      1.476969,
      10.582559,
      0.703426,
      4,
      1.927803,
      52.242630,
      2,
      70.812793,
      NULL,
      1,
      9,
      NULL,
      NULL,
      18.606124,
      33,
      2,
      NULL,
      28,
      15,
      NULL,
      NULL,
      5,
      1,
      2.958928,
      1,
      1.807311,
      69,
      ' 5-16-1993',
      ' 5-16-1992',
      ' 8- 5-2003',
      '10-11-1983',
      '11-13-1996',
      NULL,
      ' 5- 3-1993',
      NULL);
commit;
end;
/


