set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9027986';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12244344',
      '12233323',
      '04142013',
      '41343213',
      '02443040',
      '43013421',
      '42402223',
      '00101441',
      '33022333',
      '22102333',
      '23021431',
      '32101024',
      '22314241',
      '23422312',
      '02343234',
      '13130334',
      '24034423',
      '21133102',
      '30004233',
      NULL,
      '01103242',
      NULL,
      NULL,
      '00002002',
      NULL,
      NULL,
      '34313423',
      '31313441',
      '20024444',
      '10400220',
      '30202240',
      '43244213',
      '12101400',
      '42104231',
      '02240014',
      '40040440',
      '12000341',
      '03320044',
      '32341231',
      '22311412',
      '02341014',
      '00402243',
      NULL,
      '04020303',
      '',
      '',
      NULL,
      NULL,
      '3012100',
      NULL,
      NULL,
      2,
      NULL,
      '134111',
      1,
      ' 4- 7-1987',
      ' 5- 5-1978',
      NULL,
      NULL,
      NULL,
      5,
      44,
      13,
      75.581924,
      37,
      NULL,
      19.302276,
      53,
      24.799962,
      32,
      7,
      28.650614,
      16.410884,
      NULL,
      8,
      5,
      20,
      30.948582,
      3.749716,
      4.742853,
      9,
      NULL,
      172,
      11,
      89,
      195,
      271.603964,
      87.793819,
      '11-15-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      1.783005,
      NULL,
      NULL,
      NULL,
      NULL,
      1.113990,
      0.115140,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 8-1998',
      NULL,
      60,
      54.937098,
      28.798657,
      63,
      NULL,
      NULL,
      17.213461,
      14,
      18.480379,
      86.040766,
      18.779920,
      NULL,
      NULL,
      19.575110,
      17.016032,
      NULL,
      82,
      12,
      NULL,
      NULL,
      NULL,
      10,
      ' 1-24-1998',
      13.629738,
      17.094824,
      7.167486,
      2,
      3.570514,
      6.208771,
      NULL,
      19,
      NULL,
      118.044576,
      1,
      1,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 7-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      19,
      4.001651,
      ' 0-20-1986',
      0.809064,
      125.283999,
      NULL,
      1,
      10,
      11.881943,
      NULL,
      ' 7-29-1984',
      57,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40.235530,
      46.547870,
      90,
      12,
      98.592802,
      20.521899,
      13.601895,
      35.608032,
      20,
      NULL,
      17.842587,
      NULL,
      NULL,
      64.310418,
      NULL,
      NULL,
      NULL,
      1,
      5.093378,
      105.684606,
      0.043135,
      1.826779,
      83,
      128.604317,
      14,
      72.812999,
      1.258030,
      125,
      1.780205,
      1.371579,
      NULL,
      1.611480,
      0,
      0,
      75,
      72,
      77.733810,
      NULL,
      79,
      30.025744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.959304,
      NULL,
      1,
      1,
      NULL,
      18,
      8,
      NULL,
      3.715626,
      72,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      3.025813,
      NULL,
      0.113578,
      1,
      0.397695,
      11,
      NULL,
      ' 2-22-1986',
      NULL,
      NULL,
      ' 7-17-1980',
      NULL,
      NULL,
      NULL);
commit;
end;
/


