set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9749422';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      '4',
      '1',
      '1',
      NULL,
      '0',
      '3',
      '0',
      '0',
      NULL,
      '2',
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      '1',
      NULL,
      '3',
      '',
      '3',
      '',
      '0',
      NULL,
      '1',
      '4',
      '0',
      '',
      NULL,
      '3',
      '4',
      NULL,
      '4',
      '0',
      NULL,
      '0',
      '4',
      NULL,
      '4',
      NULL,
      NULL,
      '23',
      9.491728,
      16.463548,
      '4001212',
      1,
      0.849157,
      1,
      NULL,
      '303322',
      3.203375,
      ' 9-20-2000',
      NULL,
      13.254990,
      11,
      36.397980,
      16,
      35,
      15.535068,
      92,
      2,
      2,
      2.796916,
      4.021530,
      NULL,
      NULL,
      20,
      19.574569,
      2,
      28,
      24,
      NULL,
      NULL,
      50.426280,
      1.169768,
      20.538671,
      NULL,
      0.428535,
      63.722467,
      NULL,
      126,
      NULL,
      102.666734,
      NULL,
      NULL,
      NULL,
      NULL,
      31.440027,
      NULL,
      160.948474,
      221,
      ' 0- 0-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.032776,
      3.268625,
      1.287108,
      9.285430,
      NULL,
      1.580632,
      0,
      127.191907,
      1.385705,
      1,
      82.077119,
      NULL,
      NULL,
      91,
      NULL,
      NULL,
      NULL,
      ' 6-27-1984',
      14.434073,
      33,
      70,
      18.603387,
      53,
      30,
      NULL,
      54.749135,
      20.099118,
      21,
      101,
      1,
      ' 2- 9-1980',
      19.285327,
      26,
      29,
      42,
      59,
      65,
      NULL,
      ' 9-13-1977',
      NULL,
      12,
      ' 6- 2-2002',
      11.396900,
      NULL,
      15.141943,
      9,
      10.729453,
      0.075598,
      NULL,
      NULL,
      1.034876,
      131,
      0,
      0,
      3,
      NULL,
      3,
      1,
      0.533063,
      1.990850,
      ' 2-21-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      126.501862,
      0,
      '11- 4-2000',
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      36,
      NULL,
      NULL,
      5.799738,
      ' 4- 7-1987',
      46,
      21,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      ' 5-22-1981',
      65.530960,
      NULL,
      10,
      ' 7-16-1999',
      1.035588,
      48,
      ' 6-13-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


