set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9675729';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '1',
      '0',
      '1',
      NULL,
      NULL,
      '3',
      '3',
      '0',
      '3',
      '0',
      '1',
      '2',
      '3',
      '2',
      '2',
      NULL,
      '0',
      '1',
      '2',
      '0',
      '1',
      '0',
      '',
      '1',
      '',
      '3',
      NULL,
      '1',
      NULL,
      NULL,
      '',
      '',
      '1',
      '4',
      '1',
      '4',
      '0',
      '4',
      '0',
      '1',
      '4',
      '2',
      NULL,
      NULL,
      '34',
      16,
      NULL,
      '2341422',
      0.737290,
      28,
      0,
      NULL,
      '443421',
      4.060986,
      ' 4-25-1979',
      '11-11-1979',
      NULL,
      NULL,
      17.618909,
      NULL,
      11,
      2,
      51,
      1.586197,
      NULL,
      18,
      19,
      15.291415,
      18.335813,
      7,
      23.453756,
      NULL,
      NULL,
      14,
      42,
      8,
      11,
      NULL,
      27,
      4,
      1.652936,
      20,
      77.569951,
      NULL,
      31.781812,
      182.729587,
      22,
      ' 9-13-1977',
      37,
      NULL,
      30,
      37.081881,
      40,
      4,
      ' 1-19-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      55.311255,
      NULL,
      NULL,
      NULL,
      3.477840,
      6,
      ' 6-22-1995',
      1.802261,
      1.318220,
      28,
      1,
      3.234424,
      35,
      0,
      1.996719,
      101.549552,
      NULL,
      NULL,
      NULL,
      ' 4- 7-1978',
      8,
      28.834227,
      59,
      63,
      30.670615,
      NULL,
      NULL,
      59,
      NULL,
      24.160223,
      28,
      96,
      ' 1-16-1989',
      19.898030,
      24.740023,
      5.101775,
      20,
      17.103376,
      90,
      7,
      '11- 3-1998',
      26,
      NULL,
      ' 6- 6-2001',
      10,
      14,
      12,
      NULL,
      NULL,
      11,
      0,
      25.933444,
      1.137566,
      123,
      8.167201,
      0,
      NULL,
      15.453265,
      3,
      1,
      0.552835,
      NULL,
      ' 1-27-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      175.503574,
      5.282656,
      NULL,
      NULL,
      NULL,
      NULL,
      0.942044,
      NULL,
      3.957753,
      '11-17-1986',
      5.982233,
      11,
      ' 3- 2-2003',
      66,
      74.761670,
      ' 8-25-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      28.540807,
      NULL,
      NULL,
      36,
      2.193775,
      ' 3-24-1987',
      1,
      79,
      ' 6- 9-1981',
      7,
      NULL,
      NULL,
      20,
      ' 9-12-1987',
      55.250273,
      0,
      46,
      '10- 7-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


