set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023762';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0442',
      '31421104',
      '34432004',
      '42213311',
      '40103424',
      '42102300',
      '40203444',
      '31123100',
      '23443413',
      '22410110',
      '22141333',
      '14430301',
      '03440101',
      '21114043',
      '30211243',
      '30232034',
      '43121142',
      NULL,
      '40130224',
      '03204041',
      NULL,
      '02234013',
      '01430340',
      '44231423',
      '20243040',
      '00103003',
      '03030342',
      NULL,
      '11210300',
      NULL,
      '22004224',
      '40212012',
      '03341043',
      '41323244',
      NULL,
      '31334334',
      NULL,
      NULL,
      '01014031',
      '03102404',
      NULL,
      '12211024',
      '10322401',
      '41014203',
      '01213003',
      '',
      '',
      NULL,
      NULL,
      NULL,
      0.555081,
      NULL,
      NULL,
      NULL,
      '022332',
      1.869400,
      ' 3- 7-1984',
      ' 5- 7-1997',
      84.564125,
      NULL,
      18.395988,
      12.086068,
      19.681596,
      NULL,
      NULL,
      14,
      1,
      3.158148,
      1,
      NULL,
      NULL,
      10.754215,
      4,
      0,
      5.236734,
      9,
      NULL,
      1,
      17,
      12,
      NULL,
      9.473595,
      NULL,
      39.535094,
      142,
      7,
      83.403986,
      54.415302,
      151,
      NULL,
      41,
      2.392574,
      9,
      12.023082,
      60,
      1.291845,
      NULL,
      4,
      1.324391,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.947717,
      NULL,
      0,
      0.906367,
      14.301088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-23-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-17-1981',
      40.422073,
      25,
      28,
      NULL,
      68.064211,
      33.482401,
      117.936231,
      49,
      NULL,
      NULL,
      113,
      NULL,
      NULL,
      2.932956,
      NULL,
      NULL,
      34,
      50,
      NULL,
      8.126024,
      ' 3- 2-1989',
      0.706113,
      NULL,
      '11- 5-1987',
      NULL,
      1,
      NULL,
      5.539088,
      1,
      5.195485,
      NULL,
      NULL,
      NULL,
      8,
      3,
      0.651695,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-23-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33.170270,
      10,
      32.599351,
      ' 6-22-2001',
      5.991173,
      106.532627,
      '11- 3-1983',
      0.666894,
      3,
      3,
      57,
      NULL,
      5.103849,
      0.429772,
      60,
      ' 1-13-1982',
      NULL,
      NULL,
      NULL,
      12,
      66,
      68,
      12.154518,
      59,
      34.291657,
      93.757798,
      97,
      13,
      86.390487,
      7.646786,
      30,
      0,
      1.743397,
      28,
      NULL,
      NULL,
      NULL,
      1,
      3,
      129,
      1.585499,
      11,
      102,
      19.157401,
      14,
      66.376908,
      0,
      62.027665,
      1.912355,
      0.640351,
      0,
      NULL,
      NULL,
      1,
      6.869273,
      36,
      37.457411,
      10.408707,
      31,
      39.902891,
      0,
      2,
      16.948408,
      1,
      NULL,
      11.509764,
      27.986062,
      0.616617,
      44.054018,
      0,
      37,
      1,
      1,
      51,
      22.211086,
      1.495305,
      8.294897,
      41,
      21.488385,
      14.082092,
      NULL,
      NULL,
      4.242792,
      8.600441,
      0,
      1.561001,
      1.024399,
      0.065857,
      NULL,
      13,
      '11- 4-2000',
      ' 5-12-1980',
      ' 3-16-1979',
      ' 7-18-1980',
      NULL,
      NULL,
      ' 5-24-1996',
      NULL);
commit;
end;
/


