set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9505528';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0202',
      '20004000',
      '20304132',
      '01420322',
      NULL,
      NULL,
      '42212333',
      '42321243',
      '31424233',
      '32444220',
      NULL,
      '24344103',
      NULL,
      '34202412',
      '24133441',
      '32023112',
      NULL,
      NULL,
      '30310134',
      '31211043',
      '11130334',
      '21404001',
      '30113300',
      '21023210',
      '23400223',
      NULL,
      NULL,
      '01342430',
      '11214431',
      '04124133',
      '01002202',
      '23310042',
      '32121013',
      '04123041',
      '10040022',
      '32321440',
      '32430444',
      '11224311',
      NULL,
      '43124342',
      '24232102',
      NULL,
      '32444112',
      '31111413',
      NULL,
      '423',
      NULL,
      26,
      7,
      '1102331',
      NULL,
      0.223429,
      NULL,
      NULL,
      '003234',
      2,
      ' 0-17-1980',
      ' 0-24-1988',
      NULL,
      107.434148,
      15,
      11.625626,
      18,
      7,
      NULL,
      NULL,
      NULL,
      8.284395,
      9.419482,
      NULL,
      NULL,
      0,
      NULL,
      4.061085,
      9.767335,
      19.900516,
      41.123024,
      5.226507,
      1.768168,
      14.241000,
      50.079183,
      5.010305,
      1.982095,
      26,
      0,
      33,
      129.456585,
      70.763900,
      74.568530,
      ' 9-22-1987',
      8.705918,
      18.180766,
      18.483359,
      18.140982,
      82.714222,
      159,
      ' 2-26-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      0,
      28.031508,
      NULL,
      5,
      5,
      ' 1- 4-1997',
      1.420540,
      1,
      NULL,
      1,
      3.471196,
      19.619895,
      2.151911,
      0.119004,
      7,
      NULL,
      NULL,
      NULL,
      ' 8- 6-1980',
      NULL,
      94.519613,
      NULL,
      75.024914,
      71.982319,
      84.727212,
      65.679131,
      107,
      103.528422,
      NULL,
      1,
      29,
      ' 7- 5-1984',
      11,
      11,
      18.723828,
      23.065299,
      37,
      NULL,
      10.229394,
      ' 2-19-1988',
      3.987257,
      10.268467,
      ' 3-25-1987',
      NULL,
      5,
      1,
      9,
      7.546268,
      8.867788,
      1,
      NULL,
      1.946623,
      13.000636,
      1.135635,
      3,
      NULL,
      8.164197,
      5.666121,
      3.767863,
      3.093288,
      2.201842,
      ' 6-11-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      37.366627,
      NULL,
      ' 1-26-1974',
      NULL,
      NULL,
      NULL,
      9,
      ' 0-19-1977',
      14.956538,
      ' 9-12-1984',
      8.033141,
      NULL,
      NULL,
      NULL,
      23.591400,
      ' 0- 4-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      ' 1- 5-1979',
      NULL,
      0.185018,
      4,
      ' 0-29-1989',
      0,
      NULL,
      ' 0- 3-1978',
      5.851777,
      145,
      5.813457,
      NULL,
      NULL,
      37.752250,
      1.890132,
      46.894809,
      ' 8- 7-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


