set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9538351';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0122',
      '31414043',
      '33440122',
      NULL,
      '44233004',
      '21120224',
      NULL,
      NULL,
      NULL,
      '01112233',
      '12412200',
      '01132213',
      '34221114',
      '42234103',
      '14300424',
      '03431232',
      '22323222',
      '22131022',
      '13430304',
      '22332141',
      '13020404',
      '23131143',
      '33112111',
      '31410323',
      '01010223',
      '13100311',
      '12112010',
      '34120414',
      '20112013',
      '03110433',
      '33223123',
      '34131211',
      '24230421',
      '03141441',
      '21103141',
      '12002041',
      '12113103',
      NULL,
      '01100414',
      NULL,
      '42303440',
      '11021314',
      '41342330',
      '13113102',
      '41042211',
      '032',
      '32',
      NULL,
      NULL,
      '4242020',
      0.639951,
      0,
      0,
      NULL,
      '132132',
      NULL,
      NULL,
      ' 5- 7-1986',
      61,
      NULL,
      NULL,
      NULL,
      30,
      4.719366,
      66.345292,
      22.870697,
      21,
      9.397113,
      11.342932,
      NULL,
      48.679072,
      17.309140,
      27,
      7,
      36,
      19,
      NULL,
      8,
      19,
      23,
      66,
      20.426442,
      0.076086,
      6.729701,
      9,
      29,
      10.874706,
      26.422383,
      144,
      ' 8-27-2003',
      31,
      3,
      33,
      34,
      NULL,
      NULL,
      '10- 7-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      98.414914,
      3,
      10,
      0.105036,
      7.857085,
      0.014491,
      ' 8-26-1992',
      1,
      3.542065,
      80.362841,
      0,
      1.004403,
      48,
      0.569413,
      0.653246,
      50.633481,
      NULL,
      NULL,
      NULL,
      ' 8- 5-1993',
      105,
      NULL,
      17.153603,
      71.502633,
      NULL,
      NULL,
      101.090388,
      30.401425,
      94.687777,
      42,
      70.890700,
      NULL,
      ' 4-19-2001',
      29.357800,
      10,
      NULL,
      6,
      NULL,
      NULL,
      1.228270,
      ' 6-18-1976',
      5.368571,
      18.298463,
      '10-20-1997',
      2,
      9,
      13.650415,
      9,
      18.488460,
      16.192596,
      1.557012,
      NULL,
      1,
      71.959618,
      NULL,
      11,
      11.867075,
      8,
      0.287775,
      1,
      1,
      0,
      ' 6-23-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '10-25-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-19-1977',
      10.041916,
      NULL,
      9.657869,
      NULL,
      ' 9-22-1978',
      NULL,
      NULL,
      NULL,
      0,
      0.686695,
      '11-18-1989',
      NULL,
      NULL,
      NULL,
      1,
      0,
      6,
      ' 5-10-1987',
      26.005144,
      15.802151,
      37.405945,
      ' 7-27-1974',
      2.349214,
      NULL,
      ' 2- 5-1978',
      NULL,
      32.662400,
      NULL,
      17.770466,
      ' 0-20-1981',
      39.495947,
      1,
      84,
      ' 5-28-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


