set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7329044';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2113',
      '01444402',
      NULL,
      '24102401',
      '40041110',
      '34411320',
      '13224344',
      '23131421',
      NULL,
      '11432343',
      '02001143',
      '01342230',
      '01202241',
      '43211431',
      '20142032',
      '22042130',
      '44204201',
      '30302321',
      '12101424',
      NULL,
      '21233103',
      '44000014',
      '20431002',
      '20232240',
      '14333113',
      '31043004',
      '30030321',
      '43231144',
      NULL,
      NULL,
      '12221311',
      NULL,
      '00033142',
      '03121321',
      '31302424',
      '04200013',
      NULL,
      NULL,
      '01141034',
      '02014212',
      NULL,
      NULL,
      '12234110',
      '31123340',
      '01041130',
      '432',
      '04',
      25.712894,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      '124212',
      4.244667,
      ' 9-25-2002',
      NULL,
      149,
      8,
      NULL,
      7.941973,
      20.565240,
      12.000877,
      5,
      5,
      1.662437,
      6.284763,
      NULL,
      20.334584,
      NULL,
      12.813801,
      21,
      15.522132,
      21,
      10,
      55,
      14,
      NULL,
      NULL,
      4,
      28.997540,
      1,
      NULL,
      135,
      69.592817,
      NULL,
      232.426709,
      105,
      ' 0- 4-1996',
      57.364825,
      40.182751,
      32.855461,
      38,
      224.008430,
      223.169587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.518228,
      1,
      NULL,
      1.469448,
      2,
      NULL,
      ' 9-11-1985',
      0,
      1,
      64,
      0.190930,
      0.751708,
      29,
      3.136954,
      1,
      51.672959,
      NULL,
      NULL,
      NULL,
      ' 6- 4-1980',
      99.464584,
      120.762226,
      17,
      87.797636,
      107.314843,
      66.391547,
      82.691427,
      1.732741,
      21,
      NULL,
      NULL,
      67.279971,
      '11-22-2000',
      7.825559,
      NULL,
      20.907640,
      30,
      12,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      ' 4-20-2001',
      4.273250,
      23.066305,
      1,
      15,
      0.737654,
      NULL,
      1,
      NULL,
      1.975275,
      135,
      0,
      2.390597,
      30,
      13,
      1,
      0,
      0,
      NULL,
      '10- 5-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      52.729394,
      7.871375,
      ' 6-27-1991',
      NULL,
      NULL,
      NULL,
      13.733320,
      ' 6-23-1981',
      38.072938,
      ' 1-21-2002',
      15,
      NULL,
      ' 9- 2-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      9,
      ' 4-25-1994',
      48.402109,
      0,
      NULL,
      ' 9-21-1996',
      NULL,
      NULL,
      ' 5-18-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


