set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      '0',
      '4',
      '1',
      '2',
      '0',
      '2',
      '0',
      '1',
      NULL,
      NULL,
      '3',
      '3',
      '4',
      '0',
      NULL,
      '1',
      '4',
      '1',
      '4',
      '0',
      '3',
      '2',
      '',
      NULL,
      '',
      NULL,
      '1',
      '2',
      '1',
      NULL,
      '',
      '',
      '1',
      '0',
      '0',
      '3',
      NULL,
      '3',
      NULL,
      '3',
      '4',
      NULL,
      '2',
      '043',
      NULL,
      53.325178,
      35,
      '1102140',
      NULL,
      0.581302,
      3,
      NULL,
      '142101',
      4.317301,
      NULL,
      ' 7-14-1998',
      65.764746,
      98.610402,
      6,
      22,
      2,
      14,
      36,
      12.698764,
      13.683135,
      4.520204,
      41.476971,
      22,
      9.039936,
      NULL,
      NULL,
      NULL,
      7,
      16,
      61,
      5,
      57,
      12,
      78,
      15.263100,
      1,
      126.136640,
      29,
      40.098113,
      91,
      NULL,
      130,
      ' 6- 9-1977',
      17.223847,
      6,
      NULL,
      38.536398,
      169,
      103.891892,
      ' 1-19-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21.734927,
      NULL,
      2,
      NULL,
      5,
      6.773535,
      ' 9-18-1976',
      0.103292,
      1,
      154,
      1.861735,
      1,
      145,
      3.988071,
      0.020633,
      49,
      NULL,
      NULL,
      NULL,
      ' 1- 2-1988',
      NULL,
      67.723349,
      7,
      83.953376,
      38,
      53,
      79,
      54.513527,
      27,
      19.269463,
      NULL,
      66,
      '10-26-1999',
      NULL,
      NULL,
      27,
      46.900250,
      NULL,
      62.160706,
      2.237389,
      ' 1-23-1999',
      2.010396,
      NULL,
      '11-14-1995',
      15,
      16.469059,
      9.448403,
      NULL,
      23.041786,
      7.344048,
      NULL,
      1.148472,
      1.968502,
      NULL,
      NULL,
      3.937044,
      20,
      NULL,
      0.537076,
      NULL,
      1,
      NULL,
      '11-13-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      7.949036,
      0,
      ' 1-19-1990',
      NULL,
      NULL,
      NULL,
      47,
      '10-23-1999',
      13.083207,
      ' 0-18-1989',
      5.352215,
      0,
      NULL,
      143,
      8.945933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      14,
      NULL,
      48.726753,
      14,
      27.903400,
      ' 0-28-1985',
      NULL,
      97,
      '11-22-1989',
      NULL,
      21.680158,
      11,
      12.124192,
      NULL,
      58.192082,
      1.421647,
      103,
      '10-18-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


