set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3042',
      '43142330',
      '02243234',
      '23112142',
      '43103441',
      '21014212',
      '10311430',
      '33313234',
      '14404040',
      '40431222',
      '14012400',
      '10430124',
      '14441231',
      '02243424',
      '31212131',
      NULL,
      NULL,
      '22332333',
      '34102134',
      NULL,
      '04424204',
      '22323233',
      '13112411',
      '20234243',
      '14312000',
      NULL,
      '42114042',
      '11421123',
      NULL,
      '30420421',
      NULL,
      '24234122',
      '40120244',
      '12244433',
      '22211443',
      '02310220',
      '21442213',
      '03423432',
      '12210112',
      '34434022',
      '12242113',
      '10424030',
      '24320324',
      '01240033',
      '24211144',
      NULL,
      '',
      NULL,
      NULL,
      '1233312',
      5.460030,
      1.926417,
      3,
      NULL,
      '333014',
      0.681575,
      ' 0- 7-1995',
      ' 6-17-1974',
      3.802291,
      NULL,
      NULL,
      21.761852,
      NULL,
      13.068256,
      89.637018,
      20.624521,
      8,
      5,
      45.876759,
      25.492631,
      38.865226,
      NULL,
      13.048441,
      NULL,
      3,
      NULL,
      47.608157,
      NULL,
      26,
      10,
      76.224404,
      4,
      NULL,
      10.190765,
      246,
      72.896060,
      NULL,
      NULL,
      156,
      ' 9- 0-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.528106,
      3,
      0,
      3.140633,
      NULL,
      NULL,
      NULL,
      NULL,
      1.758248,
      0.384561,
      4.898757,
      1,
      NULL,
      0.990901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-12-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-10-1979',
      75,
      85,
      NULL,
      95.591298,
      23,
      35.783864,
      93.587558,
      19,
      45.038349,
      NULL,
      64.963253,
      44,
      '11-12-2001',
      NULL,
      2,
      3.362742,
      75.475358,
      59,
      NULL,
      3,
      NULL,
      18,
      18,
      ' 0-19-1987',
      8.543315,
      NULL,
      15,
      11.840079,
      9,
      NULL,
      NULL,
      19.394364,
      NULL,
      63.665513,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      67.320487,
      4,
      NULL,
      '10- 6-1983',
      NULL,
      106.346080,
      ' 6-18-1978',
      8.352076,
      10.912601,
      21.794154,
      38,
      ' 7- 6-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      67.807072,
      NULL,
      9.367246,
      NULL,
      NULL,
      37,
      NULL,
      NULL,
      27,
      NULL,
      NULL,
      1,
      0.731073,
      27,
      1.613878,
      1.439311,
      28.170562,
      0.285404,
      NULL,
      NULL,
      1,
      0.759626,
      30.372275,
      65.406545,
      23,
      24,
      0,
      NULL,
      0,
      1.592274,
      0,
      NULL,
      NULL,
      0,
      NULL,
      53.032767,
      NULL,
      16,
      17.820292,
      46.921681,
      0,
      1.380896,
      8.576405,
      1,
      0,
      0,
      13,
      1.479767,
      53,
      1.316637,
      101.455250,
      1,
      3,
      NULL,
      7.540714,
      16,
      22.729316,
      NULL,
      36,
      18.338028,
      30,
      12,
      6,
      0.193157,
      0,
      1,
      0,
      1,
      1.719400,
      68.988798,
      ' 5- 8-1994',
      NULL,
      ' 9-26-1998',
      '11-24-1979',
      NULL,
      ' 2-10-1977',
      ' 7- 0-1980',
      NULL);
commit;
end;
/


