set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0103',
      '02331000',
      '40133324',
      '33401030',
      '13344041',
      NULL,
      NULL,
      '10224304',
      NULL,
      '33130321',
      '21223132',
      '33223401',
      NULL,
      '12142204',
      '01132100',
      '12222034',
      '03143343',
      NULL,
      '22300010',
      NULL,
      '31242120',
      NULL,
      NULL,
      '40014230',
      '32222332',
      '40022134',
      '34333120',
      '23120404',
      '21033322',
      NULL,
      '13200002',
      '41000342',
      '34434021',
      '41021401',
      '04102131',
      '04103222',
      '32404413',
      '34304002',
      '42304132',
      '00102012',
      '42123130',
      '43431130',
      '02320141',
      '01102324',
      '00141244',
      '424',
      '01',
      NULL,
      NULL,
      '1304434',
      1.829853,
      NULL,
      2,
      NULL,
      NULL,
      1.593040,
      ' 0- 3-1983',
      ' 4-21-1985',
      39,
      NULL,
      NULL,
      14.172495,
      NULL,
      13,
      115,
      3,
      27,
      14.053463,
      NULL,
      8,
      34.605277,
      11.749869,
      19.797063,
      7,
      20.306176,
      1.265680,
      NULL,
      NULL,
      60.324876,
      7.456404,
      69.756756,
      17.173857,
      1.918687,
      82.461823,
      NULL,
      30,
      103,
      225,
      59.986899,
      ' 1- 8-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.397173,
      0,
      2,
      5.866886,
      2,
      9.574050,
      0.386419,
      1,
      0,
      0.667067,
      1,
      0.036912,
      NULL,
      0,
      1,
      NULL,
      1.196820,
      1.455614,
      0.070135,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-18-1996',
      NULL,
      13.574155,
      5.169939,
      0.582785,
      5,
      2,
      NULL,
      1.584567,
      NULL,
      186,
      0,
      1.999741,
      6.997893,
      0,
      1.880353,
      14,
      1.787079,
      0.144907,
      186,
      ' 4-11-1996',
      91,
      NULL,
      0.268789,
      87,
      4.404088,
      25.814032,
      5,
      45,
      NULL,
      NULL,
      12.552891,
      52,
      ' 2-21-1993',
      24,
      24.689967,
      33,
      120,
      NULL,
      NULL,
      14.055723,
      ' 0- 1-1993',
      20.941999,
      NULL,
      ' 0-10-1984',
      4.516197,
      2,
      11.772034,
      23.700146,
      29,
      0.425967,
      0,
      6.142852,
      0.143560,
      NULL,
      NULL,
      4,
      12.115388,
      23.566426,
      2.583933,
      NULL,
      2,
      1.060324,
      NULL,
      6,
      1,
      NULL,
      '10- 2-2000',
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      ' 5- 0-1998',
      39.934843,
      ' 6-28-1990',
      2,
      11,
      ' 7- 0-1996',
      NULL,
      NULL,
      NULL,
      1.795221,
      3,
      '11-11-1978',
      1,
      15,
      ' 3-15-1996',
      1,
      0,
      7,
      '11-14-1986',
      NULL,
      50.537576,
      NULL,
      ' 2-10-1978',
      NULL,
      17,
      ' 7-17-1987',
      15,
      17.691544,
      1,
      27,
      ' 1-20-1981',
      NULL,
      1,
      NULL,
      ' 7-27-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2);
commit;
end;
/


